/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.config;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.opentable.config.util.ClasspathConfigStrategy;
import com.opentable.config.util.ConfigStrategy;
import com.opentable.config.util.FileConfigStrategy;
import com.opentable.config.util.HttpConfigStrategy;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFactory.class);
    private static final Map<String, ? extends ConfigStrategyProvider> STRATEGY_PROVIDERS = ImmutableMap.of((Object)"classpath", ClasspathConfigStrategy::new, (Object)"file", FileConfigStrategy::new, (Object)"http", HttpConfigStrategy::new, (Object)"https", HttpConfigStrategy::new);
    private final String configName;
    private final URI configLocation;
    private final ConfigStrategy configStrategy;

    ConfigFactory(@Nonnull URI configLocation, @Nullable String configName) {
        this.configLocation = configLocation;
        this.configName = (String)Objects.firstNonNull((Object)configName, (Object)"default");
        this.configStrategy = this.selectConfigStrategy(configLocation);
    }

    CombinedConfiguration load() {
        LOG.info("Begin loading configuration '{}' from '{}'", (Object)this.configName, (Object)this.configLocation);
        try {
            if (this.configName.contains(",")) {
                return this.loadOTStrategy();
            }
            return this.loadNessStrategy();
        }
        catch (ConfigurationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private CombinedConfiguration loadOTStrategy() throws ConfigurationException {
        String[] configPaths = StringUtils.stripAll((String[])StringUtils.split((String)this.configName, (String)","));
        CombinedConfiguration cc = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        cc.addConfiguration((AbstractConfiguration)new SystemConfiguration(), "systemProperties");
        LOG.info("Configuration source: SYSTEM");
        for (int i = configPaths.length - 1; i >= 0; --i) {
            String configPath = configPaths[i];
            AbstractConfiguration subConfig = this.configStrategy.load(configPath, configPath);
            if (subConfig == null) {
                throw new IllegalStateException(String.format("Configuration '%s' does not exist!", configPath));
            }
            cc.addConfiguration(subConfig, configPath);
            LOG.info("New-style configuration source: {}", (Object)configPath);
        }
        return cc;
    }

    private CombinedConfiguration loadNessStrategy() {
        Object[] configNames = StringUtils.stripAll((String[])StringUtils.split((String)this.configName, (String)"/:"));
        CombinedConfiguration cc = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        cc.addConfiguration((AbstractConfiguration)new SystemConfiguration(), "systemProperties");
        LOG.info("Configuration source: SYSTEM");
        boolean loadedConfig = false;
        for (int i = 0; i < configNames.length; ++i) {
            String configFileName = configNames[configNames.length - i - 1];
            String configFilePath = StringUtils.join((Object[])configNames, (String)"/", (int)0, (int)(configNames.length - i));
            try {
                AbstractConfiguration subConfig = this.configStrategy.load(configFileName, configFilePath);
                if (subConfig == null) {
                    throw new IllegalStateException(String.format("Configuration '%s' does not exist!", configFileName));
                }
                cc.addConfiguration(subConfig, configFileName);
                LOG.info("Configuration source: {}", (Object)configFileName);
                loadedConfig = true;
                continue;
            }
            catch (ConfigurationException ce) {
                LOG.error(String.format("While loading configuration '%s'", configFileName), (Throwable)ce);
            }
        }
        if (!loadedConfig && configNames.length > 0) {
            throw new IllegalStateException(String.format("Config name '%s' was given but no config file could be found, this looks fishy!", this.configName));
        }
        return cc;
    }

    private ConfigStrategy selectConfigStrategy(URI configLocation) {
        ConfigStrategyProvider configStrategyProvider = STRATEGY_PROVIDERS.get(configLocation.getScheme());
        if (configStrategyProvider == null) {
            throw new IllegalStateException("No strategy for " + configLocation + " available!");
        }
        return configStrategyProvider.getStrategy(configLocation);
    }

    private static interface ConfigStrategyProvider {
        public ConfigStrategy getStrategy(URI var1);
    }
}

