/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.opentable.config.Config;
import com.opentable.config.ConfigDynamicMBean;
import com.opentable.config.ConfigMagicDynamicMBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ConfigJmxExporter {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigJmxExporter.class);
    private static final String ROOT = ConfigJmxExporter.class.getPackage().getName();
    private final Config config;
    @GuardedBy(value="this")
    private MBeanServer server;
    @GuardedBy(value="this")
    private final List<Map.Entry<? extends Class<?>, Object>> delayedBeanExports = new ArrayList();
    @GuardedBy(value="this")
    private final Set<String> currentExports = Sets.newHashSet();

    @Inject
    ConfigJmxExporter(Config config) {
        this.config = config;
    }

    @Inject(optional=true)
    synchronized void setMBeanServer(MBeanServer server) {
        Preconditions.checkArgument((server != null ? 1 : 0) != 0, (Object)"null MBeanServer");
        if (this.server != server) {
            this.currentExports.clear();
        }
        this.server = server;
        try {
            this.exportConfig();
        }
        catch (JMException e) {
            LOG.error("Unable to export configuration tree to JMX", (Throwable)e);
        }
        for (Map.Entry<Class<?>, Object> e : this.delayedBeanExports) {
            this.export(e.getKey(), e.getValue());
        }
    }

    private void exportConfig() throws JMException {
        this.server.registerMBean(new ConfigDynamicMBean("com.opentable.config.Config", this.config), new ObjectName(ROOT + ":config=ROOT"));
    }

    synchronized void export(Class<?> realClass, Object configBean) {
        MBeanServer server = this.server;
        if (server == null) {
            this.delayedBeanExports.add(Maps.immutableEntry(realClass, (Object)configBean));
            return;
        }
        String mungedName = this.munge(realClass.getName());
        if (!this.currentExports.add(mungedName)) {
            return;
        }
        try {
            server.registerMBean(new ConfigMagicDynamicMBean(realClass.getName(), configBean), new ObjectName(mungedName));
        }
        catch (Exception e) {
            LOG.error("Unable to export config bean " + configBean.getClass().getName(), (Throwable)e);
        }
    }

    private String munge(String name) {
        int i = 0;
        StringBuilder result = new StringBuilder(ROOT);
        result.append(':');
        for (String part : Splitter.on((char)'.').split((CharSequence)name)) {
            if (i > 0) {
                result.append(',');
            }
            result.append('n');
            result.append(i++);
            result.append('=');
            result.append(part);
        }
        return result.toString();
    }
}

