/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.config;

import com.google.common.collect.Maps;
import com.opentable.config.AbstractDynamicMBean;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.skife.config.cglib.core.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigMagicDynamicMBean
extends AbstractDynamicMBean {
    private static final String CONFIG_MAGIC_CALLBACKS_NAME = "callbacks";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMagicDynamicMBean.class);

    ConfigMagicDynamicMBean(String name, Object configBean) {
        super(name, ConfigMagicDynamicMBean.toMap(configBean));
    }

    private static Map<String, Object> toMap(Object configBean) {
        PropertyDescriptor[] props = ReflectUtils.getBeanGetters(configBean.getClass());
        HashMap result = Maps.newHashMap();
        for (PropertyDescriptor prop : props) {
            if (CONFIG_MAGIC_CALLBACKS_NAME.equals(prop.getName())) continue;
            try {
                result.put(prop.getName(), ObjectUtils.toString((Object)prop.getReadMethod().invoke(configBean, new Object[0]), null));
            }
            catch (Exception e) {
                LOG.error(String.format("For class %s, unable to find config property %s", configBean.getClass(), prop), (Throwable)e);
            }
        }
        return result;
    }
}

