/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.config;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import com.opentable.config.Config;
import com.opentable.config.ConfigJmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigModule.class);
    private final Provider<Config> configProvider;

    public static ConfigModule forTesting(String ... keyValuePairs) {
        return new ConfigModule(Config.getFixedConfig(keyValuePairs));
    }

    public static ConfigModule forTesting() {
        return new ConfigModule(Config.getEmptyConfig());
    }

    public ConfigModule() {
        this.configProvider = new Provider<Config>(){

            public Config get() {
                return Config.getConfig();
            }
        };
    }

    public ConfigModule(Config config) {
        this.configProvider = Providers.of((Object)config);
    }

    @Deprecated
    public ConfigModule(String ... keyValuePairs) {
        this(Config.getFixedConfig(keyValuePairs));
    }

    public void configure() {
        this.bind(Config.class).toProvider(this.configProvider).in(Scopes.SINGLETON);
        this.bind(ConfigJmxExporter.class).asEagerSingleton();
        this.bind(ConfigDebugger.class).asEagerSingleton();
    }

    static class ConfigDebugger {
        @Inject
        ConfigDebugger(Config config) {
            LOG.debug("Built configuration: {}", (Object)config);
        }
    }
}

