/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeFLOAT
extends OracleType
implements Serializable {
    static final long serialVersionUID = 4088841548269771109L;
    int precision;

    protected OracleTypeFLOAT() {
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    @Override
    public int getTypeCode() {
        return 6;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readUnsignedByte();
    }

    @Override
    public int getScale() {
        return -127;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    protected static Object unpickle81NativeArray(PickleContext pickleContext, long l2, int n2, int n3) throws SQLException {
        return OracleTypeNUMBER.unpickle81NativeArray(pickleContext, l2, n2, n3);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n2, map);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readInt();
    }
}

