/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.cli.CliParser;
import oracle.jdbc.driver.cli.Command;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.CommandRegistry;
import oracle.jdbc.driver.cli.DefaultCommand;
import oracle.jdbc.driver.cli.GetVersionCommand;
import oracle.jdbc.driver.cli.InstallTcpFastOpenLibCommand;
import oracle.jdbc.driver.cli.ShowConfigurationCommand;
import oracle.jdbc.driver.cli.urlbuilder.BuildUrlCommand;

public class OracleDriverCli {
    public static void main(String[] args) {
        try {
            CommandRegistry commandRegistry = new CommandRegistry();
            commandRegistry.registerCommand(new DefaultCommand(commandRegistry));
            commandRegistry.registerCommand(new ShowConfigurationCommand());
            commandRegistry.registerCommand(new GetVersionCommand());
            commandRegistry.registerCommand(new InstallTcpFastOpenLibCommand());
            commandRegistry.registerCommand(new BuildUrlCommand());
            CliParser parser = new CliParser();
            String commandName = OracleDriverCli.getCommandName(args);
            Command command = commandRegistry.getCommand(commandName);
            if (command == null) {
                throw new Exception("Unknown command: " + commandName);
            }
            CommandContext context = parser.parse(command, args);
            context.setCommandPrefix("java -jar " + OracleDriver.getJarName() + " ");
            command.validateParameters(context);
            command.execute(context);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static String getCommandName(String[] args) {
        return args.length != 0 && !args[0].startsWith("-") ? args[0].trim() : "";
    }
}

