/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;

public class OracleConnectionPoolDataSourceConnectionFactoryAdapter
extends ConnectionPoolDataSourceConnectionFactoryAdapter {
    static final String CLASS_NAME = OracleConnectionPoolDataSourceConnectionFactoryAdapter.class.getName();

    public OracleConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionPoolDataSource, diagnosticsCollector);
        this.initializeUrlFromConnectionFactory();
    }

    public OracleConnectionPoolDataSourceConnectionFactoryAdapter(ConnectionPoolDataSource connectionPoolDataSource) throws UniversalConnectionPoolException {
        this(connectionPoolDataSource, DiagnosticsCollectorImpl.getCommon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            this.trace(Level.FINEST, CLASS_NAME, "createConnection", "Oracle Connection Pool Datasource CFA: about to create connection", null, null, new Object[0]);
            String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
            Properties props = null;
            PooledConnection connection = null;
            try {
                if (null == instanceName || "".equals(instanceName) || !(this.m_connectionPoolDataSource instanceof OracleConnectionPoolDataSource)) {
                    this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection without specifying instance", null, null, new Object[0]);
                    connection = (PooledConnection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
                } else {
                    ConnectionPoolDataSource connectionPoolDataSource = this.m_connectionPoolDataSource;
                    synchronized (connectionPoolDataSource) {
                        try {
                            props = ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).getConnectionProperties();
                            if (null != props) {
                                props.setProperty("oracle.jdbc.targetInstanceName", instanceName);
                                ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).setConnectionProperties(props);
                            }
                            this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection to the instance [0]", null, null, instanceName);
                            connection = (PooledConnection)super.createConnection((ConnectionRetrievalInfo)connectionRequestInfo);
                        }
                        catch (SQLException e) {
                            this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
                        }
                        finally {
                            if (null != props) {
                                props.remove("oracle.jdbc.targetInstanceName");
                                try {
                                    ((OracleConnectionPoolDataSource)this.m_connectionPoolDataSource).setConnectionProperties(props);
                                }
                                catch (SQLException e) {
                                    this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                                    UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
                                }
                            }
                        }
                    }
                }
                if (null != connection) {
                    this.onSuccessfulConnectionCreation(connection);
                }
            }
            catch (Throwable e) {
                this.onFailedConnectionCreation(e);
                this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
                if (null != connection) {
                    this.closeConnection(connection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
            }
            PooledConnection pooledConnection = connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "returning {0}", null, null, pooledConnection);
            return pooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public UniversalPooledConnection createPooledConnection(Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void connectionRequestInfo;
            void connection;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createPooledConnection", "entering args ({0}, {1})", null, null, object, connectionRetrievalInfo);
            JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
            OracleUniversalPooledConnection oracleUniversalPooledConnection = new OracleUniversalPooledConnection(jdbccp, (Object)connection, (ConnectionRetrievalInfo)connectionRequestInfo, jdbccp.isFailoverEnabled());
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createPooledConnection", "returning {0}", null, null, oracleUniversalPooledConnection);
            return oracleUniversalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "createPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void initializeUrlFromConnectionFactory() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "entering args ()", null, null, new Object[0]);
            Class<?> dsClass = this.m_connectionPoolDataSource.getClass();
            Class<?> cls = null;
            try {
                cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
                Method m = cls.getMethod("getURL", new Class[0]);
                this.m_url = (String)m.invoke((Object)this.m_connectionPoolDataSource, new Object[0]);
                this.trace(Level.FINEST, CLASS_NAME, "initializeUrlFromConnectionFactory", "succeeded", null, null, new Object[0]);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "initializeUrlFromConnectionFactory", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "initializeUrlFromConnectionFactory", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setUrl(String string) {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "setUrl", "entering args ({0})", null, null, string);
            Class<?> dsClass = this.m_connectionPoolDataSource.getClass();
            Class<?> cls = null;
            try {
                void url;
                cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
                Method m = cls.getMethod("setURL", String.class);
                m.invoke((Object)this.m_connectionPoolDataSource, url);
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "setUrl", "", null, exc, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "setUrl", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleConnectionPoolDataSourceConnectionFactoryAdapter", "setUrl", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }
}

