/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.xml.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigurationParser
implements Parser {
    private Schema schema;
    private static XMLConfigurationParser xmlParserInstance = null;

    private XMLConfigurationParser() throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(XMLConfigurationParser.class.getResourceAsStream("configuration.xsd"));
        this.schema = factory.newSchema(schemaSource);
    }

    public static synchronized XMLConfigurationParser getInstance() throws Exception {
        if (xmlParserInstance == null) {
            xmlParserInstance = new XMLConfigurationParser();
        }
        return xmlParserInstance;
    }

    @Override
    public Map<String, Object> parse(URI xmlFilePath) throws Exception {
        boolean isFilePathValid = this.validateURI(xmlFilePath);
        if (!isFilePathValid) {
            throw new UniversalConnectionPoolException("File path is Invalid", 387);
        }
        boolean isSchemaValidationPassed = this.validateAgainstSchema(xmlFilePath);
        if (!isSchemaValidationPassed) {
            throw new UniversalConnectionPoolException("XML configuration is not valid as per schema", 387);
        }
        return this.parseDocumentURI(xmlFilePath);
    }

    @Override
    public Map<String, Object> parse(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        return this.parseDocument(document);
    }

    private Map<String, Object> parseDocumentURI(URI xmlFilePath) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(xmlFilePath));
        return this.parseDocument(document);
    }

    private Map<String, Object> parseDocument(Document document) throws Exception {
        HashMap<String, Object> parsedXMLMap = new HashMap<String, Object>();
        document.getDocumentElement().normalize();
        NodeList connectionPoolList = document.getElementsByTagName("connection-pool");
        if (connectionPoolList.getLength() > 0) {
            parsedXMLMap.putAll(this.parseAllConnectionPools(connectionPoolList));
        }
        return parsedXMLMap;
    }

    private Map<String, Object> parseAllConnectionPools(NodeList connectionPoolElementsList) throws Exception {
        HashMap<String, Object> parsedConnPoolMap = new HashMap<String, Object>();
        HashSet<String> dataSources = new HashSet<String>();
        for (int connPoolIndex = 0; connPoolIndex < connectionPoolElementsList.getLength(); ++connPoolIndex) {
            Node oneConnectionPoolNode = connectionPoolElementsList.item(connPoolIndex);
            HashMap onePool = (HashMap)this.parseOneConnectionPool(oneConnectionPoolNode);
            String poolName = (String)onePool.get("connection-pool-name");
            if (parsedConnPoolMap.containsKey(poolName)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(275);
            }
            for (String property : onePool.keySet()) {
                if (!property.startsWith("data-source-") || dataSources.add(property)) continue;
                UCPErrorHandler.throwUniversalConnectionPoolException(276);
            }
            parsedConnPoolMap.put(poolName, onePool);
        }
        return parsedConnPoolMap;
    }

    Map<String, Object> parseOneConnectionPool(Node connectionPoolElement) throws UniversalConnectionPoolException {
        HashMap<String, Object> oneConnectionPool = new HashMap<String, Object>();
        if (connectionPoolElement.getNodeType() == 1) {
            NamedNodeMap connectionPoolElementMap = connectionPoolElement.getAttributes();
            for (int attributeIndex = 0; attributeIndex < connectionPoolElementMap.getLength(); ++attributeIndex) {
                Node nodeInner = connectionPoolElementMap.item(attributeIndex);
                String attributeName = nodeInner.getNodeName();
                String attributeValue = nodeInner.getNodeValue();
                if ("password".equals(attributeName) || "wallet-password".equals(attributeName)) {
                    oneConnectionPool.put(attributeName, OpaqueString.newOpaqueString(attributeValue));
                    continue;
                }
                oneConnectionPool.put(attributeName, attributeValue);
            }
            NodeList dataSourceNodes = ((Element)connectionPoolElement).getElementsByTagName("data-source");
            if (dataSourceNodes.getLength() > 1 && !Boolean.parseBoolean((String)oneConnectionPool.get("shared"))) {
                UCPErrorHandler.throwUniversalConnectionPoolException(273);
            }
            if (dataSourceNodes.getLength() > 0) {
                for (int dataSourceNodesIndex = 0; dataSourceNodesIndex < dataSourceNodes.getLength(); ++dataSourceNodesIndex) {
                    Node dataSourceNode = dataSourceNodes.item(dataSourceNodesIndex);
                    NamedNodeMap dataSourceNodeAttributes = dataSourceNode.getAttributes();
                    if (dataSourceNodeAttributes.getLength() <= 0) continue;
                    HashMap<String, Object> dataSourceNodeMap = new HashMap<String, Object>();
                    for (int index = 0; index < dataSourceNodeAttributes.getLength(); ++index) {
                        Node nodeInner = dataSourceNodeAttributes.item(index);
                        String attributeName = nodeInner.getNodeName();
                        String attributeValue = nodeInner.getNodeValue();
                        if ("password".equals(attributeName) || "wallet-password".equals(attributeName)) {
                            dataSourceNodeMap.put(attributeName, OpaqueString.newOpaqueString(attributeValue));
                            continue;
                        }
                        dataSourceNodeMap.put(attributeName, attributeValue);
                    }
                    NodeList pdbRolePropertyNodes = ((Element)dataSourceNode).getElementsByTagName("pdb-role");
                    Properties pdbRoleProperty = new Properties();
                    if (pdbRolePropertyNodes.getLength() > 0) {
                        for (int index = 0; index < pdbRolePropertyNodes.getLength(); ++index) {
                            Node node = pdbRolePropertyNodes.item(index);
                            NamedNodeMap pdbRoleNodeMap = node.getAttributes();
                            if (pdbRoleNodeMap.getLength() <= 0) continue;
                            String pdbRoleName = pdbRoleNodeMap.item(0).getNodeValue();
                            String pdbRolePasswordValue = pdbRoleNodeMap.item(1).getNodeValue();
                            pdbRoleProperty.put(pdbRoleName, pdbRolePasswordValue);
                        }
                        dataSourceNodeMap.put("pdb-role", pdbRoleProperty);
                    }
                    String dataSourceName = (String)dataSourceNodeMap.get("data-source-name");
                    String dataSourceTag = "data-source-" + dataSourceName;
                    if (oneConnectionPool.containsKey(dataSourceTag)) {
                        UCPErrorHandler.throwUniversalConnectionPoolException(276);
                    }
                    oneConnectionPool.put(dataSourceTag, dataSourceNodeMap);
                }
            }
            NodeList connectionFactoryPropertyNodes = ((Element)connectionPoolElement).getElementsByTagName("connection-factory-property");
            Properties connectionFactoryProperty = new Properties();
            if (connectionFactoryPropertyNodes.getLength() > 0) {
                for (int index = 0; index < connectionFactoryPropertyNodes.getLength(); ++index) {
                    Node node = connectionFactoryPropertyNodes.item(index);
                    NamedNodeMap connectionFactoryNodeMap = node.getAttributes();
                    if (connectionFactoryNodeMap.getLength() <= 0) continue;
                    String connectionFactoryPropertyName = connectionFactoryNodeMap.item(0).getNodeValue();
                    String connectionFactoryPropertyValue = connectionFactoryNodeMap.item(1).getNodeValue();
                    connectionFactoryProperty.put(connectionFactoryPropertyName, connectionFactoryPropertyValue);
                }
                oneConnectionPool.put("connection-factory-property", connectionFactoryProperty);
            }
            NodeList connectionPropertyNodes = ((Element)connectionPoolElement).getElementsByTagName("connection-property");
            Properties connectionProperty = new Properties();
            if (connectionPropertyNodes.getLength() > 0) {
                for (int index = 0; index < connectionPropertyNodes.getLength(); ++index) {
                    Node connectionPropertyNode = connectionPropertyNodes.item(index);
                    NamedNodeMap connectionPropertyNodeMap = connectionPropertyNode.getAttributes();
                    if (connectionPropertyNodeMap.getLength() <= 0) continue;
                    String connectionPropertyName = connectionPropertyNodeMap.item(0).getNodeValue();
                    String connectionPropertyValue = connectionPropertyNodeMap.item(1).getNodeValue();
                    connectionProperty.put(connectionPropertyName, connectionPropertyValue);
                }
                oneConnectionPool.put("connection-property", connectionProperty);
            }
        }
        return oneConnectionPool;
    }

    public static Map<String, Object> getPoolConfigForDataSource(String dataSourceName, Map<String, Map<String, Object>> configMap) {
        if (configMap.size() == 0) {
            throw new IllegalStateException("XML file not present or not parsed");
        }
        for (Map.Entry<String, Map<String, Object>> poolConfigEntry : configMap.entrySet()) {
            Map<String, Object> poolConfigMap = poolConfigEntry.getValue();
            if (!poolConfigMap.containsKey("data-source-" + dataSourceName)) continue;
            return poolConfigMap;
        }
        return null;
    }

    public static String getPoolNameForDataSource(String dataSourceName, Map<String, Map<String, Object>> configMap) {
        if (configMap.size() == 0) {
            throw new IllegalStateException("XML file not present or not parsed");
        }
        for (Map.Entry<String, Map<String, Object>> poolConfigEntry : configMap.entrySet()) {
            Map<String, Object> poolConfigMap = poolConfigEntry.getValue();
            if (!poolConfigMap.containsKey("data-source-" + dataSourceName)) continue;
            return poolConfigEntry.getKey();
        }
        return null;
    }

    public boolean validateAgainstSchema(URI xmlFilePath) throws Exception {
        if (null != this.schema) {
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(new File(xmlFilePath)));
            return true;
        }
        throw new UniversalConnectionPoolException("XML Schema for validation is not found", 387);
    }

    public boolean validateAgainstSchema(InputStream is) throws Exception {
        if (null != this.schema) {
            Validator validator = this.schema.newValidator();
            validator.validate(new StreamSource(is));
            return true;
        }
        throw new UniversalConnectionPoolException("XML Schema for validation is not found", 387);
    }

    public boolean validateURI(URI xmlFilePath) {
        if (xmlFilePath.toString().endsWith(".xml")) {
            File xmlFile = new File(xmlFilePath);
            return null != xmlFile;
        }
        return false;
    }
}

