/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.queries;

import java.util.List;
import java.util.ArrayList;

import javax.persistence.FieldResult;
import javax.persistence.EntityResult;

/**
 * Object to hold onto an entity result metadata.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataEntityResult {
    protected EntityResult m_entityResult;
    protected List<MetadataFieldResult> m_fieldResults;
    
    /**
     * INTERNAL:
     */
    protected MetadataEntityResult() {}

    /**
     * INTERNAL:
     */
    public MetadataEntityResult(EntityResult entityResult) {
        m_entityResult = entityResult;
    }
    
    /**
     * INTERNAL:
     */
    public String getDiscriminatorColumn() {
        return m_entityResult.discriminatorColumn();
    }
    
    /**
     * INTERNAL:
     */
    public Class getEntityClass() {
        return m_entityResult.entityClass();
    }
    
    /**
     * INTERNAL:
     */
    public List<MetadataFieldResult> getFieldResults() {
        if (m_fieldResults == null) {
            m_fieldResults = new ArrayList<MetadataFieldResult>();
            
            for (FieldResult fieldResult : m_entityResult.fields()) {
                m_fieldResults.add(new MetadataFieldResult(fieldResult));
            } 
        }
        
        return m_fieldResults;
    }
}
