/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.indirection;

import oracle.toplink.essentials.indirection.*;

/**
 * Used as the backup value holder in the unit of work for transparent indirection.
 * This ensure that a reference to the original value holder is held in case the
 * transparent collection or proxy is replace without first instantiating the original.
 *
 * @since 10.1.3
 * @author James Sutherland
 */
public class BackupValueHolder extends ValueHolder {

    /** Stores the original uow clone's value holder. */
    protected ValueHolderInterface unitOfWorkValueHolder;

    public BackupValueHolder(ValueHolderInterface unitOfWorkValueHolder) {
        this.unitOfWorkValueHolder = unitOfWorkValueHolder;
    }
    
    /**
     * If the original value holder was not instantiated,
     * then first instantiate it to obtain the backup value.
     */
    public Object getValue() {
        // Ensures instantiation of the original, and setting of this back value holder's value.
        getUnitOfWorkValueHolder().getValue();
        return value;
    }

    /**
     * Return the original uow clone's value holder.
     */
    public ValueHolderInterface getUnitOfWorkValueHolder() {
        return unitOfWorkValueHolder;
    }
}
