/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a SUBSTRING
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for SUBSTRING
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since TopLink 4.0
 */
public class SubstringNode extends StringFunctionNode {
    private Node startPosition = null;
    private Node stringLength = null;

    /**
     * SubstringNode constructor comment.
     */
    public SubstringNode() {
        super();
    }

    /** 
     * INTERNAL 
     * Check the child nodes for an unqualified field access and if so,
     * replace them by a qualified field access.     
     */
    public Node qualifyAttributeAccess(ParseTreeContext context) {
       if (left != null) {
           left = left.qualifyAttributeAccess(context);
       }
       if (startPosition != null) {
           startPosition = startPosition.qualifyAttributeAccess(context);
       }
       if (stringLength != null) {
           stringLength = stringLength.qualifyAttributeAccess(context);
       }
       return this;
    }

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (left != null) {
            left.validate(context);
            left.validateParameter(context, typeHelper.getStringType());
        }
        if (startPosition != null) {
            startPosition.validate(context);
            startPosition.validateParameter(context, typeHelper.getIntType());
        }
        if (stringLength != null) {
            stringLength.validate(context);
            stringLength.validateParameter(context, typeHelper.getIntType());
        }
        setType(typeHelper.getStringType());
    }

    /**
     * INTERNAL
     * Generate the TopLink expression for this node
     */
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = getLeft().generateExpression(context);
        Expression startPosition = getStartPosition().generateExpression(context);
        Expression stringLength = getStringLength().generateExpression(context);
        whereClause = whereClause.substring(startPosition, stringLength);
        return whereClause;
    }

    /**
     * Return the start position object
     */
    private Node getStartPosition() {
        return startPosition;
    }

    /**
     * Return the string length object
     */
    private Node getStringLength() {
        return stringLength;
    }

    /**
     * Insert the method's description here.
     * Creation date: (1/19/01 3:41:55 PM)
     * @param newStartPosition java.lang.Integer
     */
    public void setStartPosition(Node newStartPosition) {
        startPosition = newStartPosition;
    }

    /**
     * Insert the method's description here.
     * Creation date: (1/19/01 3:42:26 PM)
     * @param newStringLength java.lang.Integer
     */
    public void setStringLength(Node newStringLength) {
        stringLength = newStringLength;
    }
}
