/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.sequencing;

import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.threetier.ClientSession;

/**
 * SequencingFactory is private to TopLink.
 * It instantiates sequencing classes for sessions.
 * It allows sequencing classes to be incupsulated in
 * this package.
 *
 * @see ClientSessionSequencing
 * @see RemoteConnectionSequencing
 * @see SessionBrokerSequencing
 * @see SequencingManager
 *
 */
public class SequencingFactory {

    /**
    * INTERNAL:
    * Takes a potential owner - a Session, returns Sequencing object.
    * Note that before creating a Sequencing object there is a check performed
    * to determine whether the object could be created.
    */
    public static Sequencing createSequencing(AbstractSession session) {
        Sequencing sequencing = null;
        if (session.isClientSession()) {
            ClientSession cs = (ClientSession)session;
            if (ClientSessionSequencing.sequencingServerExists(cs)) {
                sequencing = new ClientSessionSequencing(cs);
            }
        }
        return sequencing;
    }

    /**
    * INTERNAL:
    * Takes a potential owner - a DatabaseSession, returns SequencingHome object.
    * Only DatabaseSession and ServerSession should be passed (not SessionBroker).
    */
    public static SequencingHome createSequencingHome(DatabaseSessionImpl ownerSession) {
        SequencingHome home = null;
        if (!ownerSession.isBroker()) {
            home = new SequencingManager(ownerSession);
        }
        return home;
    }
}
