/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.model.kv.TxError;
import java.math.BigInteger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTxError
extends TxError {
    private final Optional<BigInteger> opIndex;
    private final Optional<String> what;

    private ImmutableTxError(Optional<BigInteger> opIndex, Optional<String> what) {
        this.opIndex = opIndex;
        this.what = what;
    }

    @Override
    @JsonProperty(value="OpIndex")
    public Optional<BigInteger> opIndex() {
        return this.opIndex;
    }

    @Override
    @JsonProperty(value="What")
    public Optional<String> what() {
        return this.what;
    }

    public final ImmutableTxError withOpIndex(BigInteger value) {
        Optional newValue = Optional.of((Object)value);
        if (this.opIndex.isPresent() && this.opIndex.get() == value) {
            return this;
        }
        return new ImmutableTxError((Optional<BigInteger>)newValue, this.what);
    }

    public final ImmutableTxError withOpIndex(Optional<BigInteger> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"opIndex");
        if (!this.opIndex.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.opIndex.isPresent() && value.isPresent() && this.opIndex.get() == value.get()) {
            return this;
        }
        return new ImmutableTxError((Optional<BigInteger>)value, this.what);
    }

    public final ImmutableTxError withWhat(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.what.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTxError(this.opIndex, (Optional<String>)newValue);
    }

    public final ImmutableTxError withWhat(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"what");
        if (this.what.equals((Object)value)) {
            return this;
        }
        return new ImmutableTxError(this.opIndex, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTxError && this.equalTo((ImmutableTxError)another);
    }

    private boolean equalTo(ImmutableTxError another) {
        return this.opIndex.equals(another.opIndex) && this.what.equals(another.what);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.opIndex.hashCode();
        h = h * 17 + this.what.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TxError").omitNullValues().add("opIndex", this.opIndex.orNull()).add("what", this.what.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTxError fromJson(Json json) {
        Builder builder = ImmutableTxError.builder();
        if (json.opIndex != null) {
            builder.opIndex(json.opIndex);
        }
        if (json.what != null) {
            builder.what(json.what);
        }
        return builder.build();
    }

    public static ImmutableTxError copyOf(TxError instance) {
        if (instance instanceof ImmutableTxError) {
            return (ImmutableTxError)instance;
        }
        return ImmutableTxError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<BigInteger> opIndex = Optional.absent();
        private Optional<String> what = Optional.absent();

        private Builder() {
        }

        public final Builder from(TxError instance) {
            Optional<String> whatOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<BigInteger> opIndexOptional = instance.opIndex();
            if (opIndexOptional.isPresent()) {
                this.opIndex(opIndexOptional);
            }
            if ((whatOptional = instance.what()).isPresent()) {
                this.what(whatOptional);
            }
            return this;
        }

        public final Builder opIndex(BigInteger opIndex) {
            this.opIndex = Optional.of((Object)opIndex);
            return this;
        }

        public final Builder opIndex(Optional<BigInteger> opIndex) {
            this.opIndex = (Optional)Preconditions.checkNotNull(opIndex, (Object)"opIndex");
            return this;
        }

        public final Builder what(String what) {
            this.what = Optional.of((Object)what);
            return this;
        }

        public final Builder what(Optional<String> what) {
            this.what = (Optional)Preconditions.checkNotNull(what, (Object)"what");
            return this;
        }

        public ImmutableTxError build() {
            return new ImmutableTxError(this.opIndex, this.what);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends TxError {
        Optional<BigInteger> opIndex = Optional.absent();
        Optional<String> what = Optional.absent();

        Json() {
        }

        @JsonProperty(value="OpIndex")
        public void setOpIndex(Optional<BigInteger> opIndex) {
            this.opIndex = opIndex;
        }

        @JsonProperty(value="What")
        public void setWhat(Optional<String> what) {
            this.what = what;
        }

        @Override
        public Optional<BigInteger> opIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> what() {
            throw new UnsupportedOperationException();
        }
    }
}

