/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.operator.RaftServer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableRaftServer
extends RaftServer {
    private final String id;
    private final String node;
    private final String address;
    private final Boolean leader;
    private final Boolean voter;

    private ImmutableRaftServer(String id, String node, String address, Boolean leader, Boolean voter) {
        this.id = id;
        this.node = node;
        this.address = address;
        this.leader = leader;
        this.voter = voter;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String address() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Leader")
    public Boolean leader() {
        return this.leader;
    }

    @Override
    @JsonProperty(value="Voter")
    public Boolean voter() {
        return this.voter;
    }

    public final ImmutableRaftServer withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableRaftServer((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.node, this.address, this.leader, this.voter);
    }

    public final ImmutableRaftServer withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.leader, this.voter);
    }

    public final ImmutableRaftServer withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.leader, this.voter);
    }

    public final ImmutableRaftServer withLeader(Boolean value) {
        if (this.leader.equals(value)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, this.address, (Boolean)Preconditions.checkNotNull((Object)value, (Object)"leader"), this.voter);
    }

    public final ImmutableRaftServer withVoter(Boolean value) {
        if (this.voter.equals(value)) {
            return this;
        }
        return new ImmutableRaftServer(this.id, this.node, this.address, this.leader, (Boolean)Preconditions.checkNotNull((Object)value, (Object)"voter"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRaftServer && this.equalTo((ImmutableRaftServer)another);
    }

    private boolean equalTo(ImmutableRaftServer another) {
        return this.id.equals(another.id) && this.node.equals(another.node) && this.address.equals(another.address) && this.leader.equals(another.leader) && this.voter.equals(another.voter);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.leader.hashCode();
        h = h * 17 + this.voter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RaftServer").omitNullValues().add("id", (Object)this.id).add("node", (Object)this.node).add("address", (Object)this.address).add("leader", (Object)this.leader).add("voter", (Object)this.voter).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableRaftServer fromJson(Json json) {
        Builder builder = ImmutableRaftServer.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.leader != null) {
            builder.leader(json.leader);
        }
        if (json.voter != null) {
            builder.voter(json.voter);
        }
        return builder.build();
    }

    public static ImmutableRaftServer copyOf(RaftServer instance) {
        if (instance instanceof ImmutableRaftServer) {
            return (ImmutableRaftServer)instance;
        }
        return ImmutableRaftServer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NODE = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private static final long INIT_BIT_LEADER = 8L;
        private static final long INIT_BIT_VOTER = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private Boolean leader;
        @Nullable
        private Boolean voter;

        private Builder() {
        }

        public final Builder from(RaftServer instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.id());
            this.node(instance.node());
            this.address(instance.address());
            this.leader(instance.leader());
            this.voter(instance.voter());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder leader(Boolean leader) {
            this.leader = (Boolean)Preconditions.checkNotNull((Object)leader, (Object)"leader");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder voter(Boolean voter) {
            this.voter = (Boolean)Preconditions.checkNotNull((Object)voter, (Object)"voter");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRaftServer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRaftServer(this.id, this.node, this.address, this.leader, this.voter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("leader");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("voter");
            }
            return "Cannot build RaftServer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends RaftServer {
        @Nullable
        String id;
        @Nullable
        String node;
        @Nullable
        String address;
        @Nullable
        Boolean leader;
        @Nullable
        Boolean voter;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Leader")
        public void setLeader(Boolean leader) {
            this.leader = leader;
        }

        @JsonProperty(value="Voter")
        public void setVoter(Boolean voter) {
            this.voter = voter;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String address() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean leader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean voter() {
            throw new UnsupportedOperationException();
        }
    }
}

