/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util;

import com.google.common.collect.Sets;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.async.Callback;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import java.io.IOException;
import java.math.BigInteger;
import okhttp3.Headers;
import retrofit2.Call;
import retrofit2.Response;

public class Http {
    public static boolean isSuccessful(Response<?> response, Integer ... okCodes) {
        return response.isSuccessful() || Sets.newHashSet((Object[])okCodes).contains(response.code());
    }

    public static <T> T extract(Call<T> call, Integer ... okCodes) {
        Response response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new ConsulException(e);
        }
        if (Http.isSuccessful(response, okCodes)) {
            return (T)response.body();
        }
        throw new ConsulException(response.code(), response);
    }

    public static void handle(Call<Void> call, Integer ... okCodes) {
        Response response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new ConsulException(e);
        }
        if (!Http.isSuccessful(response, okCodes)) {
            throw new ConsulException(response.code(), response);
        }
    }

    public static <T> ConsulResponse<T> extractConsulResponse(Call<T> call, Integer ... okCodes) {
        Response response;
        try {
            response = call.execute();
        }
        catch (IOException e) {
            throw new ConsulException(e);
        }
        if (!Http.isSuccessful(response, okCodes)) {
            throw new ConsulException(response.code(), response);
        }
        return Http.consulResponse(response);
    }

    public static <T> void extractConsulResponse(Call<T> call, final ConsulResponseCallback<T> callback, final Integer ... okCodes) {
        call.enqueue(new retrofit2.Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (Http.isSuccessful(response, okCodes)) {
                    callback.onComplete(Http.consulResponse(response));
                } else {
                    callback.onFailure(new ConsulException(response.code(), response));
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    public static <T> void extractBasicResponse(Call<T> call, final Callback<T> callback, final Integer ... okCodes) {
        call.enqueue(new retrofit2.Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (Http.isSuccessful(response, okCodes)) {
                    callback.onResponse(response.body());
                } else {
                    callback.onFailure(new ConsulException(response.code(), response));
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                callback.onFailure(t);
            }
        });
    }

    private static <T> ConsulResponse<T> consulResponse(Response<T> response) {
        Headers headers = response.headers();
        String indexHeaderValue = headers.get("X-Consul-Index");
        String lastContactHeaderValue = headers.get("X-Consul-Lastcontact");
        String knownLeaderHeaderValue = headers.get("X-Consul-Knownleader");
        BigInteger index = indexHeaderValue == null ? new BigInteger("0") : new BigInteger(indexHeaderValue);
        long lastContact = lastContactHeaderValue == null ? 0L : Long.valueOf(lastContactHeaderValue);
        boolean knownLeader = knownLeaderHeaderValue == null ? false : Boolean.valueOf(knownLeaderHeaderValue);
        ConsulResponse<Object> consulResponse = new ConsulResponse<Object>(response.body(), lastContact, knownLeader, index);
        return consulResponse;
    }
}

