/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;

public class OServerCommandGetListDatabases
extends OServerCommandAuthenticatedServerAbstract {
    private static final String[] NAMES = new String[]{"GET|listDatabases"};

    public OServerCommandGetListDatabases() {
        super("server.listDatabases");
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        return this.authenticate(iRequest, iResponse, false);
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.url, 1, "Syntax error: server");
        iRequest.data.commandInfo = "Server status";
        ODocument result = new ODocument();
        LinkedHashSet<String> storageNames = new LinkedHashSet<String>(this.server.getAvailableStorageNames().keySet());
        if (this.server.getSecurity() != null && this.server.getSecurity().isAuthorized("guest", "server.listDatabases.system")) {
            storageNames.add("OSystem");
        }
        ArrayList<String> orderedStorages = new ArrayList<String>(storageNames);
        Collections.sort(orderedStorages, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        result.field("databases", orderedStorages);
        iResponse.writeRecord((ORecord)result);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

