/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ServiceException
extends RuntimeException
implements SafeLoggable {
    private final ErrorType errorType;
    private final List<Arg<?>> args;
    private final String errorInstanceId;
    private final String unsafeMessage;
    private final String noArgsMessage;

    public ServiceException(ErrorType errorType, Arg<?> ... parameters) {
        this(errorType, (Throwable)null, parameters);
    }

    public ServiceException(ErrorType errorType, @Nullable Throwable cause, Arg<?> ... args) {
        super(cause);
        this.errorInstanceId = ServiceException.generateErrorInstanceId(cause);
        this.errorType = errorType;
        this.args = ServiceException.copyToUnmodifiableList(args);
        this.unsafeMessage = ServiceException.renderUnsafeMessage(errorType, args);
        this.noArgsMessage = ServiceException.renderNoArgsMessage(errorType);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorInstanceId() {
        return this.errorInstanceId;
    }

    @Override
    public String getMessage() {
        return this.unsafeMessage;
    }

    public String getLogMessage() {
        return this.noArgsMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.args;
    }

    @Deprecated
    public List<Arg<?>> getParameters() {
        return this.getArgs();
    }

    private static <T> List<T> copyToUnmodifiableList(T[] elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T item : elements) {
            if (item == null) continue;
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    private static String renderUnsafeMessage(ErrorType errorType, Arg<?> ... args) {
        String message = ServiceException.renderNoArgsMessage(errorType);
        if (args == null || args.length == 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append(message).append(": {");
        for (Arg<?> arg : args) {
            if (arg == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(arg.getName()).append("=").append(arg.getValue());
        }
        builder.append("}");
        return builder.toString();
    }

    private static String renderNoArgsMessage(ErrorType errorType) {
        return String.format("ServiceException: %s (%s)", new Object[]{errorType.code(), errorType.name()});
    }

    private static String generateErrorInstanceId(@Nullable Throwable cause) {
        return ServiceException.generateErrorInstanceId(cause, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static String generateErrorInstanceId(@Nullable Throwable cause, Set<Throwable> dejaVu) {
        if (cause == null || !dejaVu.add(cause)) {
            return UUID.randomUUID().toString();
        }
        if (cause instanceof ServiceException) {
            return ((ServiceException)cause).getErrorInstanceId();
        }
        if (cause instanceof RemoteException) {
            return ((RemoteException)cause).getError().errorInstanceId();
        }
        return ServiceException.generateErrorInstanceId(cause.getCause(), dejaVu);
    }
}

