package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.logsafe.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

@Generated("com.palantir.conjure.java.types.UnionGenerator")
public final class Event {
    private final Base value;

    @JsonCreator
    private Event(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return value;
    }

    public static Event build(BuildEvent value) {
        return new Event(new BuildWrapper(value));
    }

    public static Event pull(PullEvent value) {
        return new Event(new PullWrapper(value));
    }

    public static Event up(UpEvent value) {
        return new Event(new UpWrapper(value));
    }

    public static Event waitForServices(WaitForServicesEvent value) {
        return new Event(new WaitForServicesWrapper(value));
    }

    public static Event clusterWait(ClusterWaitEvent value) {
        return new Event(new ClusterWaitWrapper(value));
    }

    public static Event shutdownStop(ShutdownStopEvent value) {
        return new Event(new ShutdownStopWrapper(value));
    }

    public static Event logCollection(LogCollectionEvent value) {
        return new Event(new LogCollectionWrapper(value));
    }

    public static Event shutdown(ShutdownEvent value) {
        return new Event(new ShutdownWrapper(value));
    }

    public <T> T accept(Visitor<T> visitor) {
        if (value instanceof BuildWrapper) {
            return visitor.visitBuild(((BuildWrapper) value).value);
        } else if (value instanceof PullWrapper) {
            return visitor.visitPull(((PullWrapper) value).value);
        } else if (value instanceof UpWrapper) {
            return visitor.visitUp(((UpWrapper) value).value);
        } else if (value instanceof WaitForServicesWrapper) {
            return visitor.visitWaitForServices(((WaitForServicesWrapper) value).value);
        } else if (value instanceof ClusterWaitWrapper) {
            return visitor.visitClusterWait(((ClusterWaitWrapper) value).value);
        } else if (value instanceof ShutdownStopWrapper) {
            return visitor.visitShutdownStop(((ShutdownStopWrapper) value).value);
        } else if (value instanceof LogCollectionWrapper) {
            return visitor.visitLogCollection(((LogCollectionWrapper) value).value);
        } else if (value instanceof ShutdownWrapper) {
            return visitor.visitShutdown(((ShutdownWrapper) value).value);
        } else if (value instanceof UnknownWrapper) {
            return visitor.visitUnknown(((UnknownWrapper) value).getType());
        }
        throw new IllegalStateException(
                String.format("Could not identify type %s", value.getClass()));
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Event && equalTo((Event) other));
    }

    private boolean equalTo(Event other) {
        return this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return new StringBuilder("Event")
                .append('{')
                .append("value")
                .append(": ")
                .append(value)
                .append('}')
                .toString();
    }

    public interface Visitor<T> {
        T visitBuild(BuildEvent value);

        T visitPull(PullEvent value);

        T visitUp(UpEvent value);

        T visitWaitForServices(WaitForServicesEvent value);

        T visitClusterWait(ClusterWaitEvent value);

        T visitShutdownStop(ShutdownStopEvent value);

        T visitLogCollection(LogCollectionEvent value);

        T visitShutdown(ShutdownEvent value);

        T visitUnknown(String unknownType);
    }

    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            property = "type",
            visible = true,
            defaultImpl = UnknownWrapper.class)
    @JsonSubTypes({
        @JsonSubTypes.Type(BuildWrapper.class),
        @JsonSubTypes.Type(PullWrapper.class),
        @JsonSubTypes.Type(UpWrapper.class),
        @JsonSubTypes.Type(WaitForServicesWrapper.class),
        @JsonSubTypes.Type(ClusterWaitWrapper.class),
        @JsonSubTypes.Type(ShutdownStopWrapper.class),
        @JsonSubTypes.Type(LogCollectionWrapper.class),
        @JsonSubTypes.Type(ShutdownWrapper.class)
    })
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Base {}

    @JsonTypeName("build")
    private static class BuildWrapper implements Base {
        private final BuildEvent value;

        @JsonCreator
        private BuildWrapper(@JsonProperty("build") BuildEvent value) {
            Preconditions.checkNotNull(value, "build cannot be null");
            this.value = value;
        }

        @JsonProperty("build")
        private BuildEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof BuildWrapper && equalTo((BuildWrapper) other));
        }

        private boolean equalTo(BuildWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("BuildWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("pull")
    private static class PullWrapper implements Base {
        private final PullEvent value;

        @JsonCreator
        private PullWrapper(@JsonProperty("pull") PullEvent value) {
            Preconditions.checkNotNull(value, "pull cannot be null");
            this.value = value;
        }

        @JsonProperty("pull")
        private PullEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof PullWrapper && equalTo((PullWrapper) other));
        }

        private boolean equalTo(PullWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("PullWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("up")
    private static class UpWrapper implements Base {
        private final UpEvent value;

        @JsonCreator
        private UpWrapper(@JsonProperty("up") UpEvent value) {
            Preconditions.checkNotNull(value, "up cannot be null");
            this.value = value;
        }

        @JsonProperty("up")
        private UpEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof UpWrapper && equalTo((UpWrapper) other));
        }

        private boolean equalTo(UpWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("UpWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("waitForServices")
    private static class WaitForServicesWrapper implements Base {
        private final WaitForServicesEvent value;

        @JsonCreator
        private WaitForServicesWrapper(
                @JsonProperty("waitForServices") WaitForServicesEvent value) {
            Preconditions.checkNotNull(value, "waitForServices cannot be null");
            this.value = value;
        }

        @JsonProperty("waitForServices")
        private WaitForServicesEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof WaitForServicesWrapper
                            && equalTo((WaitForServicesWrapper) other));
        }

        private boolean equalTo(WaitForServicesWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("WaitForServicesWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("clusterWait")
    private static class ClusterWaitWrapper implements Base {
        private final ClusterWaitEvent value;

        @JsonCreator
        private ClusterWaitWrapper(@JsonProperty("clusterWait") ClusterWaitEvent value) {
            Preconditions.checkNotNull(value, "clusterWait cannot be null");
            this.value = value;
        }

        @JsonProperty("clusterWait")
        private ClusterWaitEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof ClusterWaitWrapper && equalTo((ClusterWaitWrapper) other));
        }

        private boolean equalTo(ClusterWaitWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("ClusterWaitWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("shutdownStop")
    private static class ShutdownStopWrapper implements Base {
        private final ShutdownStopEvent value;

        @JsonCreator
        private ShutdownStopWrapper(@JsonProperty("shutdownStop") ShutdownStopEvent value) {
            Preconditions.checkNotNull(value, "shutdownStop cannot be null");
            this.value = value;
        }

        @JsonProperty("shutdownStop")
        private ShutdownStopEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof ShutdownStopWrapper
                            && equalTo((ShutdownStopWrapper) other));
        }

        private boolean equalTo(ShutdownStopWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("ShutdownStopWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("logCollection")
    private static class LogCollectionWrapper implements Base {
        private final LogCollectionEvent value;

        @JsonCreator
        private LogCollectionWrapper(@JsonProperty("logCollection") LogCollectionEvent value) {
            Preconditions.checkNotNull(value, "logCollection cannot be null");
            this.value = value;
        }

        @JsonProperty("logCollection")
        private LogCollectionEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof LogCollectionWrapper
                            && equalTo((LogCollectionWrapper) other));
        }

        private boolean equalTo(LogCollectionWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("LogCollectionWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeName("shutdown")
    private static class ShutdownWrapper implements Base {
        private final ShutdownEvent value;

        @JsonCreator
        private ShutdownWrapper(@JsonProperty("shutdown") ShutdownEvent value) {
            Preconditions.checkNotNull(value, "shutdown cannot be null");
            this.value = value;
        }

        @JsonProperty("shutdown")
        private ShutdownEvent getValue() {
            return value;
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof ShutdownWrapper && equalTo((ShutdownWrapper) other));
        }

        private boolean equalTo(ShutdownWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return new StringBuilder("ShutdownWrapper")
                    .append('{')
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }

    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            include = JsonTypeInfo.As.EXISTING_PROPERTY,
            property = "type",
            visible = true)
    private static class UnknownWrapper implements Base {
        private final String type;

        private final Map<String, Object> value;

        @JsonCreator
        private UnknownWrapper(@JsonProperty("type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(String type, Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            value.put(key, val);
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof UnknownWrapper && equalTo((UnknownWrapper) other));
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(type, value);
        }

        @Override
        public String toString() {
            return new StringBuilder("UnknownWrapper")
                    .append('{')
                    .append("type")
                    .append(": ")
                    .append(type)
                    .append(", ")
                    .append("value")
                    .append(": ")
                    .append(value)
                    .append('}')
                    .toString();
        }
    }
}
