package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/** Event produced after the shutdown strategy's stop() method has been called. */
@JsonDeserialize(builder = ShutdownStopEvent.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class ShutdownStopEvent {
    private final Task task;

    private volatile int memoizedHashCode;

    private ShutdownStopEvent(Task task) {
        validateFields(task);
        this.task = task;
    }

    @JsonProperty("task")
    public Task getTask() {
        return this.task;
    }

    @Override
    public boolean equals(Object other) {
        return this == other
                || (other instanceof ShutdownStopEvent && equalTo((ShutdownStopEvent) other));
    }

    private boolean equalTo(ShutdownStopEvent other) {
        return this.task.equals(other.task);
    }

    @Override
    public int hashCode() {
        if (memoizedHashCode == 0) {
            memoizedHashCode = Objects.hash(task);
        }
        return memoizedHashCode;
    }

    @Override
    public String toString() {
        return new StringBuilder("ShutdownStopEvent")
                .append('{')
                .append("task")
                .append(": ")
                .append(task)
                .append('}')
                .toString();
    }

    public static ShutdownStopEvent of(Task task) {
        return builder().task(task).build();
    }

    private static void validateFields(Task task) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, task, "task");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set",
                    SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(
            List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Task task;

        private Builder() {}

        public Builder from(ShutdownStopEvent other) {
            task(other.getTask());
            return this;
        }

        @JsonSetter("task")
        public Builder task(Task task) {
            this.task = Preconditions.checkNotNull(task, "task cannot be null");
            return this;
        }

        public ShutdownStopEvent build() {
            return new ShutdownStopEvent(task);
        }
    }
}
