/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.docker.compose.events.Task;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class LogCollectionEvent {
    private final Task task;
    private volatile int memoizedHashCode;

    private LogCollectionEvent(Task task) {
        LogCollectionEvent.validateFields(task);
        this.task = task;
    }

    @JsonProperty(value="task")
    public Task getTask() {
        return this.task;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof LogCollectionEvent && this.equalTo((LogCollectionEvent)other);
    }

    private boolean equalTo(LogCollectionEvent other) {
        return this.task.equals(other.task);
    }

    public int hashCode() {
        if (this.memoizedHashCode == 0) {
            this.memoizedHashCode = Objects.hash(this.task);
        }
        return this.memoizedHashCode;
    }

    public String toString() {
        return "LogCollectionEvent" + '{' + "task" + ": " + this.task + '}';
    }

    public static LogCollectionEvent of(Task task) {
        return LogCollectionEvent.builder().task(task).build();
    }

    private static void validateFields(Task task) {
        List<String> missingFields = null;
        if ((missingFields = LogCollectionEvent.addFieldIfMissing(missingFields, task, "task")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Task task;

        private Builder() {
        }

        public Builder from(LogCollectionEvent other) {
            this.task(other.getTask());
            return this;
        }

        @JsonSetter(value="task")
        public Builder task(Task task) {
            this.task = (Task)Preconditions.checkNotNull((Object)task, (String)"task cannot be null");
            return this;
        }

        public LogCollectionEvent build() {
            return new LogCollectionEvent(this.task);
        }
    }
}

