package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import com.palantir.logsafe.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

/**
 * Differentiates cluster waits as being for docker-compose &quot;native healthchecks&quot; or user supplied code.
 * <p>
 * This class is used instead of a native enum to support unknown values.
 * Rather than throw an exception, the {@link ClusterWaitType#valueOf} method defaults to a new instantiation of
 * {@link ClusterWaitType} where {@link ClusterWaitType#get} will return {@link ClusterWaitType.Value#UNKNOWN}.
 * <p>
 * For example, {@code ClusterWaitType.valueOf("corrupted value").get()} will return {@link ClusterWaitType.Value#UNKNOWN},
 * but {@link ClusterWaitType#toString} will return "corrupted value".
 * <p>
 * There is no method to access all instantiations of this class, since they cannot be known at compile time.
 */
@Generated("com.palantir.conjure.java.types.EnumGenerator")
@Immutable
public final class ClusterWaitType {
    public static final ClusterWaitType NATIVE = new ClusterWaitType(Value.NATIVE, "NATIVE");

    public static final ClusterWaitType USER = new ClusterWaitType(Value.USER, "USER");

    private static final List<ClusterWaitType> values = Collections.unmodifiableList(Arrays.asList(NATIVE, USER));

    private final Value value;

    private final String string;

    private ClusterWaitType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @Override
    public boolean equals(Object other) {
        return (this == other)
                || (other instanceof ClusterWaitType && this.string.equals(((ClusterWaitType) other).string));
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static ClusterWaitType valueOf(@Nonnull String value) {
        Preconditions.checkNotNull(value, "value cannot be null");
        String upperCasedValue = value.toUpperCase(Locale.ROOT);
        switch (upperCasedValue) {
            case "NATIVE":
                return NATIVE;
            case "USER":
                return USER;
            default:
                return new ClusterWaitType(Value.UNKNOWN, upperCasedValue);
        }
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (value) {
            case NATIVE:
                return visitor.visitNative();
            case USER:
                return visitor.visitUser();
            default:
                return visitor.visitUnknown(string);
        }
    }

    public static List<ClusterWaitType> values() {
        return values;
    }

    @Generated("com.palantir.conjure.java.types.EnumGenerator")
    public enum Value {
        NATIVE,

        USER,

        UNKNOWN
    }

    @Generated("com.palantir.conjure.java.types.EnumGenerator")
    public interface Visitor<T> {
        T visitNative();

        T visitUser();

        T visitUnknown(String unknownValue);
    }
}
