package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@JsonDeserialize(builder = Report.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class Report {
    private final String reportApiVersion;

    private final String reportId;

    private final OffsetDateTime submittedTime;

    private final Optional<String> username;

    private final GitInfo gitInfo;

    private final Map<String, String> whitelistedEnvironmentVariables;

    private final Versions versions;

    private final List<DockerComposeRun> runs;

    private final List<String> exceptions;

    private int memoizedHashCode;

    private Report(
            String reportApiVersion,
            String reportId,
            OffsetDateTime submittedTime,
            Optional<String> username,
            GitInfo gitInfo,
            Map<String, String> whitelistedEnvironmentVariables,
            Versions versions,
            List<DockerComposeRun> runs,
            List<String> exceptions) {
        validateFields(
                reportApiVersion,
                reportId,
                submittedTime,
                username,
                gitInfo,
                whitelistedEnvironmentVariables,
                versions,
                runs,
                exceptions);
        this.reportApiVersion = reportApiVersion;
        this.reportId = reportId;
        this.submittedTime = submittedTime;
        this.username = username;
        this.gitInfo = gitInfo;
        this.whitelistedEnvironmentVariables = Collections.unmodifiableMap(whitelistedEnvironmentVariables);
        this.versions = versions;
        this.runs = Collections.unmodifiableList(runs);
        this.exceptions = Collections.unmodifiableList(exceptions);
    }

    @JsonProperty("reportApiVersion")
    public String getReportApiVersion() {
        return this.reportApiVersion;
    }

    @JsonProperty("reportId")
    public String getReportId() {
        return this.reportId;
    }

    @JsonProperty("submittedTime")
    public OffsetDateTime getSubmittedTime() {
        return this.submittedTime;
    }

    @JsonProperty("username")
    public Optional<String> getUsername() {
        return this.username;
    }

    @JsonProperty("gitInfo")
    public GitInfo getGitInfo() {
        return this.gitInfo;
    }

    @JsonProperty("whitelistedEnvironmentVariables")
    public Map<String, String> getWhitelistedEnvironmentVariables() {
        return this.whitelistedEnvironmentVariables;
    }

    @JsonProperty("versions")
    public Versions getVersions() {
        return this.versions;
    }

    @JsonProperty("runs")
    public List<DockerComposeRun> getRuns() {
        return this.runs;
    }

    @JsonProperty("exceptions")
    public List<String> getExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Report && equalTo((Report) other));
    }

    private boolean equalTo(Report other) {
        return this.reportApiVersion.equals(other.reportApiVersion)
                && this.reportId.equals(other.reportId)
                && this.submittedTime.isEqual(other.submittedTime)
                && this.username.equals(other.username)
                && this.gitInfo.equals(other.gitInfo)
                && this.whitelistedEnvironmentVariables.equals(other.whitelistedEnvironmentVariables)
                && this.versions.equals(other.versions)
                && this.runs.equals(other.runs)
                && this.exceptions.equals(other.exceptions);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(
                    this.reportApiVersion,
                    this.reportId,
                    this.submittedTime.toInstant(),
                    this.username,
                    this.gitInfo,
                    this.whitelistedEnvironmentVariables,
                    this.versions,
                    this.runs,
                    this.exceptions);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Report{reportApiVersion: " + reportApiVersion + ", reportId: " + reportId + ", submittedTime: "
                + submittedTime + ", username: " + username + ", gitInfo: " + gitInfo
                + ", whitelistedEnvironmentVariables: " + whitelistedEnvironmentVariables + ", versions: " + versions
                + ", runs: " + runs + ", exceptions: " + exceptions + '}';
    }

    private static void validateFields(
            String reportApiVersion,
            String reportId,
            OffsetDateTime submittedTime,
            Optional<String> username,
            GitInfo gitInfo,
            Map<String, String> whitelistedEnvironmentVariables,
            Versions versions,
            List<DockerComposeRun> runs,
            List<String> exceptions) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, reportApiVersion, "reportApiVersion");
        missingFields = addFieldIfMissing(missingFields, reportId, "reportId");
        missingFields = addFieldIfMissing(missingFields, submittedTime, "submittedTime");
        missingFields = addFieldIfMissing(missingFields, username, "username");
        missingFields = addFieldIfMissing(missingFields, gitInfo, "gitInfo");
        missingFields =
                addFieldIfMissing(missingFields, whitelistedEnvironmentVariables, "whitelistedEnvironmentVariables");
        missingFields = addFieldIfMissing(missingFields, versions, "versions");
        missingFields = addFieldIfMissing(missingFields, runs, "runs");
        missingFields = addFieldIfMissing(missingFields, exceptions, "exceptions");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(9);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private String reportApiVersion;

        private String reportId;

        private OffsetDateTime submittedTime;

        private Optional<String> username = Optional.empty();

        private GitInfo gitInfo;

        private Map<String, String> whitelistedEnvironmentVariables = new LinkedHashMap<>();

        private Versions versions;

        private List<DockerComposeRun> runs = new ArrayList<>();

        private List<String> exceptions = new ArrayList<>();

        private Builder() {}

        public Builder from(Report other) {
            reportApiVersion(other.getReportApiVersion());
            reportId(other.getReportId());
            submittedTime(other.getSubmittedTime());
            username(other.getUsername());
            gitInfo(other.getGitInfo());
            whitelistedEnvironmentVariables(other.getWhitelistedEnvironmentVariables());
            versions(other.getVersions());
            runs(other.getRuns());
            exceptions(other.getExceptions());
            return this;
        }

        @JsonSetter("reportApiVersion")
        public Builder reportApiVersion(@Nonnull String reportApiVersion) {
            this.reportApiVersion = Preconditions.checkNotNull(reportApiVersion, "reportApiVersion cannot be null");
            return this;
        }

        @JsonSetter("reportId")
        public Builder reportId(@Nonnull String reportId) {
            this.reportId = Preconditions.checkNotNull(reportId, "reportId cannot be null");
            return this;
        }

        @JsonSetter("submittedTime")
        public Builder submittedTime(@Nonnull OffsetDateTime submittedTime) {
            this.submittedTime = Preconditions.checkNotNull(submittedTime, "submittedTime cannot be null");
            return this;
        }

        @JsonSetter(value = "username", nulls = Nulls.SKIP)
        public Builder username(@Nonnull Optional<String> username) {
            this.username = Preconditions.checkNotNull(username, "username cannot be null");
            return this;
        }

        public Builder username(@Nonnull String username) {
            this.username = Optional.of(Preconditions.checkNotNull(username, "username cannot be null"));
            return this;
        }

        @JsonSetter("gitInfo")
        public Builder gitInfo(@Nonnull GitInfo gitInfo) {
            this.gitInfo = Preconditions.checkNotNull(gitInfo, "gitInfo cannot be null");
            return this;
        }

        @JsonSetter(value = "whitelistedEnvironmentVariables", nulls = Nulls.SKIP)
        public Builder whitelistedEnvironmentVariables(@Nonnull Map<String, String> whitelistedEnvironmentVariables) {
            this.whitelistedEnvironmentVariables.clear();
            this.whitelistedEnvironmentVariables.putAll(Preconditions.checkNotNull(
                    whitelistedEnvironmentVariables, "whitelistedEnvironmentVariables cannot be null"));
            return this;
        }

        public Builder putAllWhitelistedEnvironmentVariables(
                @Nonnull Map<String, String> whitelistedEnvironmentVariables) {
            this.whitelistedEnvironmentVariables.putAll(Preconditions.checkNotNull(
                    whitelistedEnvironmentVariables, "whitelistedEnvironmentVariables cannot be null"));
            return this;
        }

        public Builder whitelistedEnvironmentVariables(String key, String value) {
            this.whitelistedEnvironmentVariables.put(key, value);
            return this;
        }

        @JsonSetter("versions")
        public Builder versions(@Nonnull Versions versions) {
            this.versions = Preconditions.checkNotNull(versions, "versions cannot be null");
            return this;
        }

        @JsonSetter(value = "runs", nulls = Nulls.SKIP)
        public Builder runs(@Nonnull Iterable<DockerComposeRun> runs) {
            this.runs.clear();
            ConjureCollections.addAll(this.runs, Preconditions.checkNotNull(runs, "runs cannot be null"));
            return this;
        }

        public Builder addAllRuns(@Nonnull Iterable<DockerComposeRun> runs) {
            ConjureCollections.addAll(this.runs, Preconditions.checkNotNull(runs, "runs cannot be null"));
            return this;
        }

        public Builder runs(DockerComposeRun runs) {
            this.runs.add(runs);
            return this;
        }

        @JsonSetter(value = "exceptions", nulls = Nulls.SKIP)
        public Builder exceptions(@Nonnull Iterable<String> exceptions) {
            this.exceptions.clear();
            ConjureCollections.addAll(
                    this.exceptions, Preconditions.checkNotNull(exceptions, "exceptions cannot be null"));
            return this;
        }

        public Builder addAllExceptions(@Nonnull Iterable<String> exceptions) {
            ConjureCollections.addAll(
                    this.exceptions, Preconditions.checkNotNull(exceptions, "exceptions cannot be null"));
            return this;
        }

        public Builder exceptions(String exceptions) {
            this.exceptions.add(exceptions);
            return this;
        }

        public Report build() {
            return new Report(
                    reportApiVersion,
                    reportId,
                    submittedTime,
                    username,
                    gitInfo,
                    whitelistedEnvironmentVariables,
                    versions,
                    runs,
                    exceptions);
        }
    }
}
