package com.palantir.docker.compose.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@JsonDeserialize(builder = TestDescription.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class TestDescription {
    private final Optional<String> testClass;

    private final Optional<String> displayName;

    private final Optional<String> method;

    private int memoizedHashCode;

    private TestDescription(Optional<String> testClass, Optional<String> displayName, Optional<String> method) {
        validateFields(testClass, displayName, method);
        this.testClass = testClass;
        this.displayName = displayName;
        this.method = method;
    }

    @JsonProperty("testClass")
    public Optional<String> getTestClass() {
        return this.testClass;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty("method")
    public Optional<String> getMethod() {
        return this.method;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof TestDescription && equalTo((TestDescription) other));
    }

    private boolean equalTo(TestDescription other) {
        return this.testClass.equals(other.testClass)
                && this.displayName.equals(other.displayName)
                && this.method.equals(other.method);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(this.testClass, this.displayName, this.method);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "TestDescription{testClass: " + testClass + ", displayName: " + displayName + ", method: " + method
                + '}';
    }

    public static TestDescription of(String testClass, String displayName, String method) {
        return builder()
                .testClass(Optional.of(testClass))
                .displayName(Optional.of(displayName))
                .method(Optional.of(method))
                .build();
    }

    private static void validateFields(
            Optional<String> testClass, Optional<String> displayName, Optional<String> method) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, testClass, "testClass");
        missingFields = addFieldIfMissing(missingFields, displayName, "displayName");
        missingFields = addFieldIfMissing(missingFields, method, "method");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> testClass = Optional.empty();

        private Optional<String> displayName = Optional.empty();

        private Optional<String> method = Optional.empty();

        private Builder() {}

        public Builder from(TestDescription other) {
            testClass(other.getTestClass());
            displayName(other.getDisplayName());
            method(other.getMethod());
            return this;
        }

        @JsonSetter(value = "testClass", nulls = Nulls.SKIP)
        public Builder testClass(@Nonnull Optional<String> testClass) {
            this.testClass = Preconditions.checkNotNull(testClass, "testClass cannot be null");
            return this;
        }

        public Builder testClass(@Nonnull String testClass) {
            this.testClass = Optional.of(Preconditions.checkNotNull(testClass, "testClass cannot be null"));
            return this;
        }

        @JsonSetter(value = "displayName", nulls = Nulls.SKIP)
        public Builder displayName(@Nonnull Optional<String> displayName) {
            this.displayName = Preconditions.checkNotNull(displayName, "displayName cannot be null");
            return this;
        }

        public Builder displayName(@Nonnull String displayName) {
            this.displayName = Optional.of(Preconditions.checkNotNull(displayName, "displayName cannot be null"));
            return this;
        }

        @JsonSetter(value = "method", nulls = Nulls.SKIP)
        public Builder method(@Nonnull Optional<String> method) {
            this.method = Preconditions.checkNotNull(method, "method cannot be null");
            return this;
        }

        public Builder method(@Nonnull String method) {
            this.method = Optional.of(Preconditions.checkNotNull(method, "method cannot be null"));
            return this;
        }

        public TestDescription build() {
            return new TestDescription(testClass, displayName, method);
        }
    }
}
