/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.palantir.javaformat.BreakBehaviour;
import com.palantir.javaformat.BreakBehaviours;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.LastLevelBreakability;
import com.palantir.javaformat.OpenOp;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.PartialInlineability;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.CountWidthUntilBreakVisitor;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.FillMode;
import com.palantir.javaformat.doc.ImmutableLevelState;
import com.palantir.javaformat.doc.ImmutableSplitsBreaks;
import com.palantir.javaformat.doc.ImmutableSupplier;
import com.palantir.javaformat.doc.LevelDelimitedFlatValueDocVisitor;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.StartsWithBreakVisitor;
import com.palantir.javaformat.doc.State;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

public final class Level
extends Doc {
    private static final int MAX_BRANCHING_COEFFICIENT = 20;
    private static final Collector<Level, ?, Optional<Level>> GET_LAST_COLLECTOR = Collectors.reducing((u, v) -> v);
    private final List<Doc> docs = new ArrayList<Doc>();
    private final ImmutableSupplier<SplitsBreaks> memoizedSplitsBreaks = () -> ((Supplier)Suppliers.memoize(() -> Level.splitByBreaks(this.docs))).get();
    private final OpenOp openOp;

    private Level(OpenOp openOp) {
        this.openOp = openOp;
    }

    static Level make(OpenOp openOp) {
        return new Level(openOp);
    }

    void add(Doc doc) {
        this.docs.add(doc);
    }

    @Override
    protected float computeWidth() {
        float thisWidth = 0.0f;
        for (Doc doc : this.docs) {
            thisWidth += doc.getWidth();
        }
        return thisWidth;
    }

    @Override
    protected String computeFlat() {
        StringBuilder builder = new StringBuilder();
        for (Doc doc : this.docs) {
            builder.append(doc.getFlat());
        }
        return builder.toString();
    }

    @Override
    protected Range<Integer> computeRange() {
        Range<Integer> docRange = EMPTY_RANGE;
        for (Doc doc : this.docs) {
            docRange = Level.union(docRange, doc.range());
        }
        return docRange;
    }

    @Override
    public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode observer) {
        return this.tryToFitOnOneLine(maxWidth, state, this.docs).map(newWidth -> state.withColumn((int)newWidth).withLevelState(this, ImmutableLevelState.of(true))).orElseGet(() -> {
            Obs.LevelNode childLevel = observer.newChildNode(this, state);
            State newState = this.getBreakBehaviour().match(new BreakImpl(commentsHelper, maxWidth, state, childLevel));
            return childLevel.finishLevel(state.updateAfterLevel(newState));
        });
    }

    private Optional<Integer> tryToFitOnOneLine(int maxWidth, State state, Iterable<Doc> docs) {
        int column = state.column();
        int columnBeforeLastBreak = 0;
        for (Doc doc : docs) {
            if (doc instanceof Break && ((Break)doc).hasColumnLimit()) {
                columnBeforeLastBreak = column;
            } else if (doc instanceof Level) {
                Level innerLevel = (Level)doc;
                State newState = state.withColumn(column);
                Optional<Integer> newWidth = innerLevel.tryToFitOnOneLine(maxWidth, newState, innerLevel.getDocs());
                if (!newWidth.isPresent()) {
                    return Optional.empty();
                }
                column = newWidth.get();
                continue;
            }
            column = (int)((float)column + doc.getWidth());
        }
        if (this.getColumnLimitBeforeLastBreak().isPresent() && columnBeforeLastBreak > this.getColumnLimitBeforeLastBreak().getAsInt()) {
            return Optional.empty();
        }
        if (column <= maxWidth) {
            return Optional.of(column);
        }
        return Optional.empty();
    }

    private Obs.Exploration breakNormally(State state, Obs.LevelNode levelNode, CommentsHelper commentsHelper, int maxWidth) {
        State stateForBroken = state.withIndentIncrementedBy(this.getPlusIndent());
        return levelNode.explore("breaking normally", stateForBroken, explorationNode -> this.computeBroken(commentsHelper, maxWidth, stateForBroken, (Obs.ExplorationNode)explorationNode));
    }

    private Optional<State> handle_breakOnlyIfInnerLevelsThenFitOnOneLine(CommentsHelper commentsHelper, int maxWidth, State state, State brokenState, boolean keepIndent, Obs.ExplorationNode explorationNode) {
        boolean anyLevelWasBroken = this.getNonEmptyInnerLevels().anyMatch(level -> !brokenState.isOneLine((Level)level));
        if (!anyLevelWasBroken) {
            return Optional.of(brokenState);
        }
        Optional<State> partiallyInlinedStateOpt = this.tryInlinePrefixOntoCurrentLine(commentsHelper, maxWidth, state, keepIndent, explorationNode);
        if (!partiallyInlinedStateOpt.isPresent()) {
            return Optional.empty();
        }
        State partiallyInlinedState = partiallyInlinedStateOpt.get();
        boolean bodyIsComplex = this.getNonEmptyInnerLevels().anyMatch(il -> il.openOp.complexity() == OpenOp.Complexity.COMPLEX);
        if (bodyIsComplex || partiallyInlinedState.numLines() < brokenState.numLines()) {
            return Optional.of(partiallyInlinedState);
        }
        return Optional.empty();
    }

    private Stream<Level> getNonEmptyInnerLevels() {
        return this.docs.stream().filter(doc -> doc instanceof Level).map(doc -> (Level)doc).filter(doc -> StartsWithBreakVisitor.INSTANCE.visit((Doc)doc) != StartsWithBreakVisitor.Result.EMPTY);
    }

    private Optional<State> tryInlinePrefixOntoCurrentLine(CommentsHelper commentsHelper, int maxWidth, State state, boolean keepIndent, Obs.ExplorationNode explorationNode) {
        boolean fits;
        Level lastLevel = this.getNonEmptyInnerLevels().filter(doc -> StartsWithBreakVisitor.INSTANCE.visit((Doc)doc) != StartsWithBreakVisitor.Result.EMPTY).collect(GET_LAST_COLLECTOR).orElseThrow(() -> new IllegalStateException("Levels were broken so expected to find at least a non-empty level"));
        List<Doc> leadingDocs = this.docs.subList(0, this.docs.indexOf(lastLevel));
        float leadingWidth = Level.getWidth(leadingDocs);
        boolean bl = fits = !Float.isInfinite(leadingWidth += ((Float)new CountWidthUntilBreakVisitor(maxWidth - state.indent()).visit(lastLevel)).floatValue()) && (float)state.column() + leadingWidth <= (float)maxWidth;
        if (!fits) {
            return Optional.empty();
        }
        State newState = state.withNoIndent();
        if (keepIndent) {
            newState = newState.withIndentIncrementedBy(this.getPlusIndent());
        }
        return Optional.of(this.tryToLayOutLevelOnOneLine(commentsHelper, maxWidth, newState, (SplitsBreaks)this.memoizedSplitsBreaks.get(), explorationNode));
    }

    private Optional<State> tryBreakLastLevel(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode explorationNode, boolean isSimpleInliningSoFar) {
        if (this.docs.isEmpty() || !(Iterables.getLast(this.docs) instanceof Level)) {
            return Optional.empty();
        }
        Level innerLevel = (Level)Iterables.getLast(this.docs);
        return this.tryBreakInnerLevel(commentsHelper, maxWidth, state, explorationNode, innerLevel, isSimpleInliningSoFar);
    }

    private Optional<State> tryInlineSuffix(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode explorationNode, boolean isSimpleInliningSoFar) {
        Preconditions.checkState((this.docs.size() > 0 && Iterables.getLast(this.docs) instanceof Level ? 1 : 0) != 0, (Object)"Level with break behaviour inlineSuffix must end with a level as its last doc");
        Level lastLevel = (Level)Iterables.getLast(this.docs);
        Preconditions.checkState((StartsWithBreakVisitor.INSTANCE.visit(lastLevel) == StartsWithBreakVisitor.Result.YES ? 1 : 0) != 0, (Object)"Level with break behaviour inlineSuffix must have a last level that starts with a break");
        if (this.docs.size() < 2 || !(this.docs.get(this.docs.size() - 2) instanceof Level)) {
            return Optional.empty();
        }
        Level lastLevelBeforeSuffix = (Level)this.docs.get(this.docs.size() - 2);
        return this.tryBreakInnerLevel(commentsHelper, maxWidth, state, explorationNode, lastLevelBeforeSuffix, isSimpleInliningSoFar);
    }

    private Optional<State> tryBreakInnerLevel(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode explorationNode, Level innerLevel, boolean isSimpleInliningSoFar) {
        Optional<State> state2;
        if (innerLevel.getBreakabilityIfLastLevel() == LastLevelBreakability.ABORT) {
            return Optional.empty();
        }
        int innerLevelIndex = this.docs.indexOf(innerLevel);
        List<Doc> leadingDocs = this.docs.subList(0, innerLevelIndex);
        if (!this.tryToFitOnOneLine(maxWidth, state, leadingDocs).isPresent()) {
            return Optional.empty();
        }
        List<Doc> trailingDocs = this.docs.subList(innerLevelIndex + 1, this.docs.size());
        float trailingWidth = Level.getWidth(trailingDocs);
        if (Double.isInfinite(trailingWidth)) {
            return Optional.empty();
        }
        SplitsBreaks prefixSplitsBreaks = Level.splitByBreaks(leadingDocs);
        boolean isSimpleInlining = isSimpleInliningSoFar && this.openOp.complexity() == OpenOp.Complexity.SIMPLE;
        State state1 = this.tryToLayOutLevelOnOneLine(commentsHelper, maxWidth, state, prefixSplitsBreaks, explorationNode);
        if (state1.numLines() != state.numLines()) {
            return Optional.empty();
        }
        switch (innerLevel.getBreakabilityIfLastLevel()) {
            case ACCEPT_INLINE_CHAIN_IF_SIMPLE_OTHERWISE_CHECK_INNER: {
                if (isSimpleInlining) {
                    state2 = Level.tryBreakInnerLevel_acceptInlineChain(commentsHelper, maxWidth, explorationNode, innerLevel, state1);
                    break;
                }
            }
            case CHECK_INNER: {
                state2 = Level.tryBreakInnerLevel_checkInner(commentsHelper, maxWidth, explorationNode, innerLevel, isSimpleInlining, state1);
                break;
            }
            case ACCEPT_INLINE_CHAIN: {
                state2 = Level.tryBreakInnerLevel_acceptInlineChain(commentsHelper, maxWidth, explorationNode, innerLevel, state1);
                break;
            }
            case ABORT: {
                state2 = Optional.empty();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected lastLevelBreakability: " + String.valueOf((Object)innerLevel.getBreakabilityIfLastLevel()));
            }
        }
        return state2.flatMap(stateAfterInner -> this.tryToFitOnOneLine(maxWidth, (State)stateAfterInner, (Iterable<Doc>)trailingDocs).map(stateAfterInner::withColumn));
    }

    private static Optional<State> tryBreakInnerLevel_acceptInlineChain(CommentsHelper commentsHelper, int maxWidth, Obs.ExplorationNode explorationNode, Level lastLevel, State state) {
        boolean stillFits;
        float extraWidth = ((Float)new CountWidthUntilBreakVisitor(maxWidth - state.indent()).visit(lastLevel)).floatValue();
        boolean bl = stillFits = !Float.isInfinite(extraWidth) && (float)state.column() + extraWidth <= (float)maxWidth;
        if (!stillFits) {
            return Optional.empty();
        }
        return Optional.of(explorationNode.newChildNode(lastLevel, state).explore("end tryBreakLastLevel chain", state, exp -> lastLevel.computeBreaks(commentsHelper, maxWidth, state, (Obs.ExplorationNode)exp)).markAccepted());
    }

    private static Optional<State> tryBreakInnerLevel_checkInner(CommentsHelper commentsHelper, int maxWidth, Obs.ExplorationNode explorationNode, Level innerLevel, boolean isSimpleInlining, State state) {
        return BreakBehaviours.caseOf(innerLevel.getBreakBehaviour()).preferBreakingLastInnerLevel(keepIndentWhenInlined -> {
            State state1 = keepIndentWhenInlined != false ? state.withIndentIncrementedBy(innerLevel.getPlusIndent()) : state;
            return explorationNode.newChildNode(innerLevel, state1).maybeExplore("recurse into inner tryBreakLastLevel", state1, exp -> innerLevel.tryBreakLastLevel(commentsHelper, maxWidth, state1, (Obs.ExplorationNode)exp, isSimpleInlining)).map(Obs.Exploration::markAccepted);
        }).inlineSuffix(() -> explorationNode.newChildNode(innerLevel, state).maybeExplore("recurse into inner tryInlineSuffix", state, exp -> innerLevel.tryInlineSuffix(commentsHelper, maxWidth, state, (Obs.ExplorationNode)exp, isSimpleInlining)).map(Obs.Exploration::markAccepted)).breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> {
            State state1 = keepIndentWhenInlined != false ? state.withIndentIncrementedBy(innerLevel.getPlusIndent()) : state;
            String humanDescription = "end tryBreakLastLevel chain -> breakOnlyIfInnerLevelsThenFitOnOneLine";
            Obs.LevelNode levelNode = explorationNode.newChildNode(innerLevel, state1);
            return levelNode.maybeExplore(humanDescription, state1, exp -> {
                if (innerLevel.docs.isEmpty() || !(Iterables.getLast(innerLevel.docs) instanceof Level)) {
                    return Optional.empty();
                }
                Level lastLevel2 = (Level)Iterables.getLast(innerLevel.docs);
                switch (lastLevel2.getBreakabilityIfLastLevel()) {
                    case CHECK_INNER: 
                    case ABORT: {
                        return Optional.empty();
                    }
                    case ACCEPT_INLINE_CHAIN: {
                        Obs.Exploration broken = innerLevel.breakNormally(state, levelNode, commentsHelper, maxWidth);
                        return innerLevel.handle_breakOnlyIfInnerLevelsThenFitOnOneLine(commentsHelper, maxWidth, state1, broken.state(), (boolean)keepIndentWhenInlined, explorationNode);
                    }
                    case ACCEPT_INLINE_CHAIN_IF_SIMPLE_OTHERWISE_CHECK_INNER: {
                        if (lastLevel2.openOp.complexity() == OpenOp.Complexity.SIMPLE) {
                            return Optional.empty();
                        }
                        return innerLevel.tryInlinePrefixOntoCurrentLine(commentsHelper, maxWidth, state1, (boolean)keepIndentWhenInlined, explorationNode);
                    }
                }
                throw new RuntimeException("Unknown breakabilityIfLastLevel: " + String.valueOf(lastLevel2));
            }).map(Obs.Exploration::markAccepted);
        }).otherwise_(Optional.empty());
    }

    private State tryToLayOutLevelOnOneLine(CommentsHelper commentsHelper, int maxWidth, State state, SplitsBreaks splitsBreaks, Obs.ExplorationNode explorationNode) {
        for (int i = 0; i < splitsBreaks.splits().size(); ++i) {
            if (i > 0) {
                state = ((Break)splitsBreaks.breaks().get(i - 1)).computeBreaks(state, false);
            }
            List split = (List)splitsBreaks.splits().get(i);
            float splitWidth = Level.getWidth(split);
            boolean enoughRoom = (float)state.column() + splitWidth <= (float)maxWidth;
            state = Level.computeSplit(commentsHelper, maxWidth, split, state.withMustBreak(false), explorationNode);
            if (enoughRoom) continue;
            state = state.withMustBreak(true);
        }
        return state;
    }

    private static SplitsBreaks splitByBreaks(List<Doc> docs) {
        ImmutableSplitsBreaks.Builder builder = ImmutableSplitsBreaks.builder();
        ImmutableList.Builder currentSplit = ImmutableList.builder();
        for (Doc doc : docs) {
            if (doc instanceof Break) {
                builder.addSplits((ImmutableList<Doc>)currentSplit.build());
                currentSplit = ImmutableList.builder();
                builder.addBreaks((Break)doc);
                continue;
            }
            currentSplit.add((Object)doc);
        }
        builder.addSplits((ImmutableList<Doc>)currentSplit.build());
        return builder.build();
    }

    private State computeBroken(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode explorationNode) {
        SplitsBreaks splitsBreaks = (SplitsBreaks)this.memoizedSplitsBreaks.get();
        if (!splitsBreaks.breaks().isEmpty()) {
            state = state.withBrokenLevel();
        }
        ImmutableList splitDocs = (ImmutableList)splitsBreaks.splits().get(0);
        state = this.computeBreakAndSplit(commentsHelper, maxWidth, state, Optional.empty(), (List<Doc>)splitDocs, explorationNode);
        for (int i = 0; i < splitsBreaks.breaks().size(); ++i) {
            state = this.computeBreakAndSplit(commentsHelper, maxWidth, state, Optional.of((Break)splitsBreaks.breaks().get(i)), (List)splitsBreaks.splits().get(i + 1), explorationNode);
        }
        return state;
    }

    private State computeBreakAndSplit(CommentsHelper commentsHelper, int maxWidth, State state, Optional<Break> optBreakDoc, List<Doc> split, Obs.ExplorationNode explorationNode) {
        boolean shouldBreak;
        float breakWidth = optBreakDoc.isPresent() ? optBreakDoc.get().getWidth() : 0.0f;
        float splitWidth = Level.getWidth(split);
        boolean bl = shouldBreak = optBreakDoc.isPresent() && optBreakDoc.get().fillMode() == FillMode.UNIFIED || state.mustBreak() || Double.isInfinite(breakWidth) || !this.tryToFitOnOneLine(maxWidth, state.withColumn(state.column() + (int)breakWidth), split).isPresent();
        if (optBreakDoc.isPresent()) {
            state = optBreakDoc.get().computeBreaks(state, shouldBreak);
        }
        boolean enoughRoom = (float)state.column() + splitWidth <= (float)maxWidth;
        state = Level.computeSplit(commentsHelper, maxWidth, split, state.withMustBreak(false), explorationNode);
        if (!enoughRoom) {
            state = state.withMustBreak(true);
        }
        return state;
    }

    private static State computeSplit(CommentsHelper commentsHelper, int maxWidth, List<Doc> docs, State state, Obs.ExplorationNode explorationNode) {
        for (Doc doc : docs) {
            state = doc.computeBreaks(commentsHelper, maxWidth, state, explorationNode);
        }
        return state;
    }

    @Override
    public void write(State state, Output output) {
        if (state.isOneLine(this)) {
            output.append(state, this.getFlat(), this.range());
        } else {
            this.writeFilled(state, output);
        }
    }

    private void writeFilled(State state, Output output) {
        SplitsBreaks splitsBreaks = (SplitsBreaks)this.memoizedSplitsBreaks.get();
        for (Doc doc : (ImmutableList)splitsBreaks.splits().get(0)) {
            doc.write(state, output);
        }
        for (int i = 0; i < splitsBreaks.breaks().size(); ++i) {
            ((Break)splitsBreaks.breaks().get(i)).write(state, output);
            for (Doc doc : (ImmutableList)splitsBreaks.splits().get(i + 1)) {
                doc.write(state, output);
            }
        }
    }

    public Indent getPlusIndent() {
        return this.openOp.plusIndent();
    }

    BreakBehaviour getBreakBehaviour() {
        return this.openOp.breakBehaviour();
    }

    List<Doc> getDocs() {
        return this.docs;
    }

    LastLevelBreakability getBreakabilityIfLastLevel() {
        return this.openOp.breakabilityIfLastLevel();
    }

    public PartialInlineability partialInlineability() {
        return this.openOp.partialInlineability();
    }

    public Optional<String> getDebugName() {
        return this.openOp.debugName();
    }

    public OpenOp getOpenOp() {
        return this.openOp;
    }

    public OptionalInt getColumnLimitBeforeLastBreak() {
        return this.openOp.columnLimitBeforeLastBreak();
    }

    public String representation(State state) {
        return (String)new LevelDelimitedFlatValueDocVisitor(state).visit(this);
    }

    static float getWidth(Iterable<Doc> docs) {
        float width = 0.0f;
        for (Doc doc : docs) {
            width += doc.getWidth();
        }
        return width;
    }

    private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
        return x.isEmpty() ? y : (y.isEmpty() ? x : x.span(y).canonical(INTEGERS));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("debugName", this.getDebugName()).add("plusIndent", (Object)this.getPlusIndent()).add("breakBehaviour", (Object)this.getBreakBehaviour()).add("breakabilityIfLastLevel", (Object)this.getBreakabilityIfLastLevel()).toString();
    }

    @Value.Immutable
    static interface SplitsBreaks {
        public ImmutableList<ImmutableList<Doc>> splits();

        public ImmutableList<Break> breaks();
    }

    class BreakImpl
    implements BreakBehaviour.Cases<State> {
        private final CommentsHelper commentsHelper;
        private final int maxWidth;
        private final State state;
        private final Obs.LevelNode levelNode;

        public BreakImpl(CommentsHelper commentsHelper, int maxWidth, State state, Obs.LevelNode levelNode) {
            this.commentsHelper = commentsHelper;
            this.maxWidth = maxWidth;
            this.state = state;
            this.levelNode = levelNode;
        }

        private Obs.Exploration breakNormally(State state) {
            return Level.this.breakNormally(state, this.levelNode, this.commentsHelper, this.maxWidth);
        }

        @Override
        public State breakThisLevel() {
            return this.breakNormally(this.state).markAccepted();
        }

        @Override
        public State preferBreakingLastInnerLevel(boolean _keepIndentWhenInlined) {
            State state1;
            Optional<Obs.Exploration> lastLevelBroken;
            State state = this.state.withNewBranch();
            Obs.Exploration broken = this.breakNormally(state);
            if (state.branchingCoefficient() < 20 && (lastLevelBroken = this.levelNode.maybeExplore("tryBreakLastLevel", state1 = state.withNoIndent(), explorationNode -> Level.this.tryBreakLastLevel(this.commentsHelper, this.maxWidth, state1, (Obs.ExplorationNode)explorationNode, true))).isPresent() && lastLevelBroken.get().state().numLines() < broken.state().numLines()) {
                return lastLevelBroken.get().markAccepted();
            }
            return broken.markAccepted();
        }

        @Override
        public State breakOnlyIfInnerLevelsThenFitOnOneLine(boolean keepIndentWhenInlined) {
            Obs.Exploration broken = Level.this.breakNormally(this.state, this.levelNode, this.commentsHelper, this.maxWidth);
            Optional<Obs.Exploration> maybeInlined = this.levelNode.maybeExplore("handle_breakOnlyIfInnerLevelsThenFitOnOneLine", this.state, explorationNode -> Level.this.handle_breakOnlyIfInnerLevelsThenFitOnOneLine(this.commentsHelper, this.maxWidth, this.state, broken.state(), keepIndentWhenInlined, (Obs.ExplorationNode)explorationNode));
            if (maybeInlined.isPresent()) {
                return maybeInlined.get().markAccepted();
            }
            return broken.markAccepted();
        }

        @Override
        public State inlineSuffix() {
            Optional<Obs.Exploration> lastLevelBroken = this.levelNode.maybeExplore("inlineSuffix", this.state, explorationNode -> Level.this.tryInlineSuffix(this.commentsHelper, this.maxWidth, this.state, (Obs.ExplorationNode)explorationNode, true));
            return lastLevelBroken.orElseGet(() -> this.breakNormally(this.state)).markAccepted();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Value.Style(overshadowImplementation=true)
    static @interface SplitsBreaksStyle {
    }
}

