/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.When;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import java.lang.reflect.AnnotatedElement;

public class PropertyParameterContext {
    private static final long DEFAULT_SEED = (Long)Reflection.defaultValueOf(When.class, "seed");
    private final ParameterTypeContext typeContext;
    private final int sampleSize;
    private int discardRatio;
    private String constraint;
    private long seed = DEFAULT_SEED;

    public PropertyParameterContext(ParameterTypeContext typeContext, int sampleSize) {
        this.typeContext = typeContext;
        this.sampleSize = sampleSize;
    }

    public PropertyParameterContext annotate(AnnotatedElement element) {
        When quantifier = element.getAnnotation(When.class);
        this.addQuantifier(quantifier);
        this.addConstraint(quantifier);
        this.typeContext.annotate(element);
        return this;
    }

    public PropertyParameterContext addQuantifier(When quantifier) {
        if (quantifier != null) {
            this.discardRatio = this.ensureNonNegativeDiscardRatio(quantifier);
            this.seed = quantifier.seed();
        }
        return this;
    }

    public PropertyParameterContext addConstraint(When quantifier) {
        if (quantifier != null && !Reflection.defaultValueOf(When.class, "satisfies").equals(quantifier.satisfies())) {
            this.constraint = quantifier.satisfies();
        }
        return this;
    }

    public ParameterTypeContext typeContext() {
        return this.typeContext;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public int discardRatio() {
        return this.discardRatio;
    }

    public String constraint() {
        return this.constraint;
    }

    public boolean fixedSeed() {
        return this.seed != DEFAULT_SEED;
    }

    public long seed() {
        return this.seed;
    }

    private int ensureNonNegativeDiscardRatio(When quantifier) {
        if (quantifier.discardRatio() < 0) {
            throw new IllegalArgumentException("Negative discard ratio for parameter " + this.typeContext.name() + " of type " + this.typeContext.type().getTypeName());
        }
        return quantifier.discardRatio();
    }
}

