/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.RangeTree;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003Je\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\t0\u000fH\u0016J\f\u0010\u0016\u001a\u00020\r*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/MaxLineLengthRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/Rule$Modifier$Last;", "()V", "maxLineLength", "", "rangeTree", "Lcom/pinterest/ktlint/ruleset/standard/RangeTree;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isPartOfRawMultiLineString", "ktlint-ruleset-standard"})
public final class MaxLineLengthRule
extends Rule
implements Rule.Modifier.Last {
    private int maxLineLength = -1;
    private RangeTree rangeTree = new RangeTree(null, 1, null);

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            Object object = node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_USER_DATA_KEY());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.getUserData(KtLint.\u2026R_CONFIG_USER_DATA_KEY)!!");
            EditorConfig editorConfig = (EditorConfig)object;
            this.maxLineLength = editorConfig.getMaxLineLength();
            if (this.maxLineLength <= 0) {
                return;
            }
            boolean bl = false;
            ArrayList<Integer> errorOffset = new ArrayList<Integer>();
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
            String text = string;
            List lines = StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            int offset = 0;
            for (String line : lines) {
                if (line.length() > this.maxLineLength) {
                    ASTNode el;
                    PsiElement psiElement = node.getPsi().findElementAt(offset + line.length() - 1);
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi.findElementAt(offset + line.length - 1)!!");
                    ASTNode aSTNode = el = psiElement.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"el");
                    if (!PackageKt.isPartOf((ASTNode)aSTNode, (KClass)Reflection.getOrCreateKotlinClass(KDoc.class)) && !this.isPartOfRawMultiLineString(el)) {
                        if (!PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                            if (!PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtPackageDirective.class)) && !PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) {
                                errorOffset.add(offset);
                            }
                        } else {
                            ASTNode prevLeaf;
                            String string2 = el.getText();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"el.text");
                            if (!StringsKt.startsWith$default((String)string2, (String)"// ktlint-disable", (boolean)false, (int)2, null) && (prevLeaf = PackageKt.prevCodeSibling((ASTNode)el)) != null && prevLeaf.getStartOffset() >= offset) {
                                errorOffset.add(offset);
                            }
                        }
                    }
                }
                offset += line.length() + 1;
            }
            this.rangeTree = new RangeTree((List<Integer>)errorOffset);
        } else if (!this.rangeTree.isEmpty() && node.getPsi() instanceof LeafPsiElement) {
            RangeTree.ArrayView this_$iv = this.rangeTree.query(node.getStartOffset(), node.getStartOffset() + node.getTextLength());
            boolean $i$f$forEach = false;
            int i$iv = 0;
            while (i$iv < this_$iv.getSize()) {
                int offset = this_$iv.get(i$iv++);
                boolean bl = false;
                emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfRawMultiLineString(@NotNull ASTNode $this$isPartOfRawMultiLineString) {
        ASTNode aSTNode = PackageKt.parent((ASTNode)$this$isPartOfRawMultiLineString, (IElementType)ElementType.INSTANCE.getSTRING_TEMPLATE(), (boolean)false);
        if (aSTNode == null) return false;
        ASTNode aSTNode2 = aSTNode;
        boolean bl = false;
        boolean bl2 = false;
        ASTNode it = aSTNode2;
        boolean bl3 = false;
        ASTNode aSTNode3 = it.getFirstChildNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"it.firstChildNode");
        if (!Intrinsics.areEqual((Object)aSTNode3.getText(), (Object)"\"\"\"")) return false;
        if (!it.textContains('\n')) return false;
        return true;
    }

    public MaxLineLengthRule() {
        super("max-line-length");
    }
}

