/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud.publisher;

import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import java.lang.reflect.Type;
import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.web.util.UriComponentsBuilder;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.cloud.SubscriberContextUtils;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.LazyInitialized;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import rx.Observable;
import rx.RxReactiveStreams;

public class RibbonPublisherClient
implements PublisherHttpClient {
    private final LazyInitialized<LoadBalancerCommand<Object>> loadBalancerCommand = new LazyInitialized(() -> (LoadBalancerCommand)loadBalancerCommandFactory.apply(serviceName));
    private final PublisherHttpClient publisherClient;
    private final Type publisherType;

    public RibbonPublisherClient(LoadBalancerCommandFactory loadBalancerCommandFactory, String serviceName, PublisherHttpClient publisherClient, Type publisherType) {
        this.publisherClient = publisherClient;
        this.publisherType = publisherType;
    }

    public Publisher<Object> executeRequest(ReactiveHttpRequest request) {
        LoadBalancerCommand loadBalancerCommand = (LoadBalancerCommand)this.loadBalancerCommand.get();
        if (loadBalancerCommand != null) {
            if (this.publisherType == Mono.class) {
                return Mono.subscriberContext().flatMap(context -> Mono.from(this.getLoadBalancedPublisher(request, (LoadBalancerCommand<Object>)loadBalancerCommand, (Context)context)));
            }
            if (this.publisherType == Flux.class) {
                return Mono.subscriberContext().flatMapMany(context -> Flux.from(this.getLoadBalancedPublisher(request, (LoadBalancerCommand<Object>)loadBalancerCommand, (Context)context)));
            }
            throw new IllegalArgumentException("Unknown publisherType: " + this.publisherType);
        }
        return this.publisherClient.executeRequest(request);
    }

    private Publisher<?> getLoadBalancedPublisher(ReactiveHttpRequest request, LoadBalancerCommand<Object> loadBalancerCommand, Context context) {
        Observable observable = loadBalancerCommand.submit(server -> {
            ReactiveHttpRequest lbRequest = this.loadBalanceRequest(request, server);
            Publisher publisher = this.publisherClient.executeRequest(lbRequest);
            return RxReactiveStreams.toObservable((Publisher)SubscriberContextUtils.withContext(publisher, this.publisherType, context));
        });
        return RxReactiveStreams.toPublisher((Observable)observable);
    }

    protected ReactiveHttpRequest loadBalanceRequest(ReactiveHttpRequest request, Server server) {
        URI lbUrl = UriComponentsBuilder.fromUri((URI)request.uri()).host(server.getHost()).port(server.getPort()).build(true).toUri();
        return new ReactiveHttpRequest(request, lbUrl);
    }
}

