/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import feign.Contract;
import java.time.Clock;
import org.eclipse.jetty.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.client.log.DefaultReactiveLogger;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.metrics.MicrometerReactiveLogger;
import reactivefeign.cloud2.CloudReactiveFeign;
import reactivefeign.jetty.JettyHttpClientFactory;
import reactivefeign.jetty.JettyReactiveFeign;
import reactivefeign.spring.config.ReactiveFeignBasicConfigurator;
import reactivefeign.spring.config.ReactiveFeignCircuitBreakerConfigurator;
import reactivefeign.spring.config.ReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignLoadBalancerConfigurator;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.WebReactiveFeign;

@Configuration
public class ReactiveFeignClientsConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Contract reactiveFeignContract() {
        return new SpringMvcContract();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    @ConditionalOnProperty(name={"reactive.feign.metrics.enabled"}, havingValue="true")
    public MicrometerReactiveLogger metricsReactiveLogger() {
        return MicrometerReactiveLogger.basicTimer();
    }

    @Bean
    @ConditionalOnMissingBean(ignoredType={"reactivefeign.client.metrics.MicrometerReactiveLogger"})
    @ConditionalOnProperty(name={"reactive.feign.logger.enabled"}, havingValue="true")
    public ReactiveLoggerListener reactiveLogger() {
        return new DefaultReactiveLogger(Clock.systemUTC());
    }

    @Configuration
    @AutoConfigureAfter(value={ReactiveFeignConfiguration.class})
    @ConditionalOnClass(value={ReactiveCircuitBreakerFactory.class, ReactiveLoadBalancer.class, CloudReactiveFeign.class})
    @ConditionalOnProperty(name={"reactive.feign.cloud.enabled"}, havingValue="true", matchIfMissing=true)
    protected static class ReactiveFeignCloud2Configuration {
        protected ReactiveFeignCloud2Configuration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.circuit.breaker.enabled"}, havingValue="true", matchIfMissing=true)
        public ReactiveFeignConfigurator reactiveFeignResilience4jConfigurator() {
            return new ReactiveFeignCircuitBreakerConfigurator();
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
        public ReactiveFeignConfigurator reactiveFeignLoadBalancerConfigurator() {
            return new ReactiveFeignLoadBalancerConfigurator();
        }

        @Bean
        @Primary
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        public CloudReactiveFeign.Builder reactiveFeignCloudBuilder(ReactiveFeignBuilder reactiveFeignBuilder) {
            return CloudReactiveFeign.builder((ReactiveFeignBuilder)reactiveFeignBuilder);
        }
    }

    @Configuration
    protected static class ReactiveFeignConfiguration {
        protected ReactiveFeignConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        public ReactiveFeignConfigurator reactiveFeignBasicConfigurator() {
            return new ReactiveFeignBasicConfigurator();
        }

        @Configuration
        @ConditionalOnClass(value={WebReactiveFeign.class, WebClient.class})
        @ConditionalOnProperty(name={"reactive.feign.jetty", "reactive.feign.java11"}, havingValue="false", matchIfMissing=true)
        protected static class ReactiveFeignWebConfiguration {
            protected ReactiveFeignWebConfiguration() {
            }

            @Bean
            @Scope(value="prototype")
            public ReactiveFeignBuilder reactiveFeignBuilder(WebClient.Builder builder, @Autowired(required=false) WebClientFeignCustomizer webClientCustomizer) {
                return webClientCustomizer != null ? WebReactiveFeign.builder((WebClient.Builder)builder, (WebClientFeignCustomizer)webClientCustomizer) : WebReactiveFeign.builder((WebClient.Builder)builder);
            }
        }

        @Configuration
        @ConditionalOnClass(value={JettyReactiveFeign.class, HttpClient.class})
        @ConditionalOnProperty(name={"reactive.feign.jetty"}, havingValue="true")
        protected static class ReactiveFeignJettyConfiguration {
            protected ReactiveFeignJettyConfiguration() {
            }

            @Bean
            @Scope(value="prototype")
            public ReactiveFeignBuilder reactiveFeignBuilder(JettyHttpClientFactory jettyHttpClientFactory) {
                return JettyReactiveFeign.builder((JettyHttpClientFactory)jettyHttpClientFactory);
            }
        }
    }
}

