/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.elasticsearch.ElasticSearchProperties;
import com.playtika.test.elasticsearch.rest.CreateIndex;
import com.playtika.test.elasticsearch.rest.WaitForGreenStatus;
import org.slf4j.Logger;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

class ElasticSearchContainerFactory {
    ElasticSearchContainerFactory() {
    }

    static ElasticsearchContainer create(ElasticSearchProperties properties, Logger containerLogger) {
        return (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(properties.dockerImage).withExposedPorts(new Integer[]{properties.httpPort, properties.transportPort})).withEnv("cluster.name", properties.getClusterName())).withEnv("discovery.type", "single-node")).withEnv("ES_JAVA_OPTS", ElasticSearchContainerFactory.getJavaOpts(properties))).withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.NET_ADMIN}))).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)containerLogger))).waitingFor(ElasticSearchContainerFactory.getCompositeWaitStrategy(properties))).withReuse(properties.isReuseContainer())).withStartupTimeout(properties.getTimeoutDuration());
    }

    private static String getJavaOpts(ElasticSearchProperties properties) {
        return "-Xms" + properties.getClusterRamMb() + "m -Xmx" + properties.getClusterRamMb() + "m";
    }

    private static WaitStrategy getCompositeWaitStrategy(ElasticSearchProperties properties) {
        WaitAllStrategy strategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy());
        properties.indices.forEach(index -> strategy.withStrategy((WaitStrategy)new CreateIndex(properties, (String)index)));
        return strategy.withStrategy((WaitStrategy)new WaitForGreenStatus(properties)).withStartupTimeout(ContainerUtils.DEFAULT_CONTAINER_WAIT_DURATION);
    }
}

