/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.common.utils.YumPackageInstaller;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.elasticsearch.install.enabled"})
public class EmbeddedElasticSearchTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.elasticsearch.install")
    public InstallPackageProperties elasticSearchPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute"));
        return properties;
    }

    @Bean
    public PackageInstaller elasticSearchPackageInstaller(InstallPackageProperties elasticSearchPackageProperties, @Qualifier(value="embeddedElasticSearch") ElasticsearchContainer elasticSearch) {
        return new YumPackageInstaller(elasticSearchPackageProperties, (GenericContainer)elasticSearch);
    }

    @Bean
    public NetworkTestOperations elasticSearchNetworkTestOperations(@Qualifier(value="embeddedElasticSearch") ElasticsearchContainer elasticSearch) {
        return new DefaultNetworkTestOperations((GenericContainer)elasticSearch);
    }
}

