/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.playtika.test.common.properties.InstallPackageProperties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public abstract class PackageInstaller {
    private static final Logger log = LoggerFactory.getLogger(PackageInstaller.class);
    private final InstallPackageProperties properties;
    private final GenericContainer container;

    protected abstract void install(String var1);

    @PostConstruct
    protected void installPackages() {
        if (!this.properties.isEnabled()) {
            log.trace("Packages installation skipped for container: {}", (Object)this.container);
            return;
        }
        if (this.properties.getPackages().isEmpty()) {
            log.trace("No packages configured to be installed into container: {}", (Object)this.container);
            return;
        }
        this.updatePackageList();
        this.properties.getPackages().forEach(this::installPackageIfNeeded);
        log.debug("Installed packages: {} into container: {}", this.properties.getPackages(), (Object)this.container);
    }

    protected void updatePackageList() {
    }

    protected void installPackageIfNeeded(String packageToInstall) {
        if (this.shouldInstall(packageToInstall)) {
            this.install(packageToInstall);
        }
    }

    protected boolean shouldInstall(String packageToInstall) {
        Container.ExecResult result = this.executeSafely("which", packageToInstall);
        return result.getStdout().isEmpty();
    }

    protected Container.ExecResult executeSafely(String ... command) {
        try {
            return this.container.execInContainer(command);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute command", e);
        }
    }

    public PackageInstaller(InstallPackageProperties properties, GenericContainer container) {
        this.properties = properties;
        this.container = container;
    }
}

