/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.playtika.test.common.properties.CommonContainerProperties;
import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.utility.MountableFile;

public final class ContainerUtils {
    public static final Duration DEFAULT_CONTAINER_WAIT_DURATION = Duration.ofSeconds(60L);

    public static GenericContainer<?> configureCommonsAndStart(GenericContainer<?> container, CommonContainerProperties properties, Logger logger) {
        GenericContainer updatedContainer = container.withStartupTimeout(properties.getTimeoutDuration()).withReuse(properties.isReuseContainer()).withLogConsumer(ContainerUtils.containerLogsConsumer(logger)).withEnv(properties.getEnv());
        for (CommonContainerProperties.CopyFileProperties fileToCopy : properties.getFilesToInclude()) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)fileToCopy.getClasspathResource());
            updatedContainer = updatedContainer.withCopyFileToContainer(mountableFile, fileToCopy.getContainerPath());
        }
        updatedContainer = properties.getCommand() != null ? updatedContainer.withCommand(properties.getCommand()) : updatedContainer;
        ContainerUtils.startAndLogTime(updatedContainer, logger);
        return updatedContainer;
    }

    private static long startAndLogTime(GenericContainer<?> container, Logger logger) {
        Instant startTime = Instant.now();
        container.start();
        Instant endTime = Instant.now();
        long startupTime = Duration.between(startTime, endTime).toMillis() / 1000L;
        if (startupTime < 10L) {
            logger.info("{} startup time is {} seconds", (Object)container.getDockerImageName(), (Object)startupTime);
        } else if (startupTime < 20L) {
            logger.warn("{} startup time is {} seconds", (Object)container.getDockerImageName(), (Object)startupTime);
        } else {
            logger.error("{} startup time is {} seconds", (Object)container.getDockerImageName(), (Object)startupTime);
        }
        return startupTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableMappingPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port for mapping: " + e.getMessage(), e);
        }
    }

    public static Consumer<OutputFrame> containerLogsConsumer(Logger log) {
        return outputFrame -> {
            switch (outputFrame.getType()) {
                case STDERR: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                case STDOUT: 
                case END: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                default: {
                    log.debug(outputFrame.getUtf8String());
                }
            }
        };
    }

    public static Container.ExecResult executeInContainer(ContainerState container, String[] command) {
        try {
            return container.execInContainer(command);
        }
        catch (Exception e) {
            String format = String.format("Exception was thrown when executing: %s, for container: %s ", Arrays.toString(command), container.getContainerId());
            throw new IllegalStateException(format, e);
        }
    }

    private ContainerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

