/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieReader;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.QuickTimeInputStream;

public class QuickTimeReader
extends QuickTimeInputStream
implements MovieReader {
    public static final Format QUICKTIME = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, "video/quicktime"});

    public QuickTimeReader(File file) throws IOException {
        super(file);
    }

    public QuickTimeReader(ImageInputStream in) throws IOException {
        super(in);
    }

    @Override
    public long timeToSample(int track, Rational seconds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational sampleToTime(int track, long sample) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Format getFileFormat() throws IOException {
        return QUICKTIME;
    }

    @Override
    public Format getFormat(int track) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getChunkCount(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).sampleCount;
    }

    public BufferedImage read(int track, BufferedImage img) throws IOException {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        if (tr.inputBuffer == null) {
            tr.inputBuffer = new Buffer();
        }
        if (tr.codec == null) {
            this.createCodec(tr);
        }
        Buffer buf = new Buffer();
        buf.data = img;
        do {
            this.read(track, tr.inputBuffer);
            tr.codec.process(tr.inputBuffer, buf);
        } while (buf.isFlag(BufferFlag.DISCARD) && !buf.isFlag(BufferFlag.END_OF_MEDIA));
        if (tr.inputBuffer.isFlag(BufferFlag.END_OF_MEDIA)) {
            return null;
        }
        return (BufferedImage)buf.data;
    }

    @Override
    public void read(int track, Buffer buffer) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int nextTrack() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMovieReadTime(Rational newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational getReadTime(int track) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational getDuration() throws IOException {
        return new Rational(this.getMovieDuration(), this.getMovieTimeScale());
    }

    @Override
    public Rational getDuration(int track) throws IOException {
        this.ensureRealized();
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        Rational trackDuration = new Rational(tr.mediaDuration, tr.mediaTimeScale);
        return trackDuration;
    }

    @Override
    public int findTrack(int fromTrack, Format format) throws IOException {
        int n = this.getTrackCount();
        for (int i = fromTrack; i < n; ++i) {
            if (!this.getFormat(i).matches(format)) continue;
            return i;
        }
        return -1;
    }

    private void createCodec(AbstractQuickTimeStream.Track tr) {
        Format fmt = tr.format;
        Codec codec = this.createCodec(fmt);
        String enc = (String)fmt.get(VideoFormatKeys.EncodingKey);
        if (codec == null) {
            throw new UnsupportedOperationException("Track " + tr + " no codec found for format " + fmt);
        }
        if (fmt.get(VideoFormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            if (null == codec.setInputFormat(fmt)) {
                throw new UnsupportedOperationException("Track " + tr + " codec does not support input format " + fmt + ". codec=" + codec);
            }
            Format outFormat = fmt.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class});
            if (null == codec.setOutputFormat(outFormat)) {
                throw new UnsupportedOperationException("Track " + tr + " codec does not support output format " + outFormat + ". codec=" + codec);
            }
        }
        tr.codec = codec;
    }

    private Codec createCodec(Format fmt) {
        Codec[] codecs = Registry.getInstance().getDecoders(fmt.prepend(VideoFormatKeys.MimeTypeKey, "video/avi"));
        return codecs.length == 0 ? null : codecs[0];
    }
}

