/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.HashMap;

public enum IFDDataType {
    ASCII(2),
    BYTE(1),
    SHORT(3),
    LONG(4),
    RATIONAL(5),
    SBYTE(6),
    UNDEFINED(7),
    SSHORT(8),
    SLONG(9),
    SRATIONAL(10),
    FLOAT(11),
    DOUBLE(12),
    IFD(13);

    private final int typeNumber;
    private static final HashMap<Integer, IFDDataType> valueToFieldType;

    private IFDDataType(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public static IFDDataType valueOf(int typeNumber) {
        return valueToFieldType.get(typeNumber);
    }

    static {
        valueToFieldType = new HashMap();
        for (IFDDataType t : IFDDataType.values()) {
            valueToFieldType.put(t.getTypeNumber(), t);
        }
    }
}

