/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@FileStatefulCheck
public class FinalClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.class";
    private static final String PACKAGE_SEPARATOR = ".";
    private Map<String, ClassDesc> innerClasses;
    private Deque<ClassDesc> classes;
    private String packageName;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{157, 14, 154, 15, 199, 8, 16, 136};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.classes = new ArrayDeque<ClassDesc>();
        this.innerClasses = new HashMap<String, ClassDesc>();
        this.packageName = "";
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.packageName = FinalClassCheck.extractQualifiedName(ast.getFirstChild().getNextSibling());
                break;
            }
            case 15: 
            case 154: 
            case 157: 
            case 199: {
                break;
            }
            case 14: {
                this.visitClass(ast);
                break;
            }
            case 8: {
                this.visitCtor(ast);
                break;
            }
            case 136: {
                if (ast.getFirstChild() == null || ast.getLastChild().getType() != 6) break;
                for (ClassDesc classDesc : this.classes) {
                    if (!FinalClassCheck.doesNameOfClassMatchAnonymousInnerClassName(ast, classDesc)) continue;
                    classDesc.registerAnonymousInnerClass();
                }
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitClass(DetailAST ast) {
        String qualifiedClassName = this.getQualifiedClassName(ast);
        ClassDesc currClass = new ClassDesc(qualifiedClassName, this.classes.size(), ast);
        this.classes.push(currClass);
        this.innerClasses.put(qualifiedClassName, currClass);
    }

    private void visitCtor(DetailAST ast) {
        if (!ScopeUtil.isInEnumBlock(ast) && !ScopeUtil.isInRecordBlock(ast)) {
            DetailAST modifiers = ast.findFirstToken(5);
            ClassDesc desc = this.classes.getFirst();
            if (modifiers.findFirstToken(61) == null) {
                desc.registerNonPrivateCtor();
            } else {
                desc.registerPrivateCtor();
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14) {
            this.classes.pop();
        }
        if (TokenUtil.isRootNode(ast.getParent())) {
            this.innerClasses.forEach(this::registerNestedSubclassToOuterSuperClasses);
            this.innerClasses.forEach((qualifiedClassName, classDesc) -> {
                if (FinalClassCheck.shouldBeDeclaredAsFinal(classDesc)) {
                    String className = FinalClassCheck.getClassNameFromQualifiedName(qualifiedClassName);
                    this.log(classDesc.getClassAst(), MSG_KEY, className);
                }
            });
        }
    }

    private static boolean shouldBeDeclaredAsFinal(ClassDesc desc) {
        return desc.isWithPrivateCtor() && !desc.isDeclaredAsAbstract() && !desc.isWithAnonymousInnerClass() && !desc.isDeclaredAsFinal() && !desc.isWithNonPrivateCtor() && !desc.isWithNestedSubclass();
    }

    private static String extractQualifiedName(DetailAST ast) {
        return FullIdent.createFullIdent(ast).getText();
    }

    private void registerNestedSubclassToOuterSuperClasses(String qualifiedClassName, ClassDesc currentClass) {
        String superClassName = FinalClassCheck.getSuperClassName(currentClass.getClassAst());
        if (superClassName != null) {
            ClassDesc nearest = this.getNearestClassWithSameName(superClassName, qualifiedClassName);
            if (nearest == null) {
                Optional.ofNullable(this.innerClasses.get(superClassName)).ifPresent(rec$ -> ((ClassDesc)rec$).registerNestedSubclass());
            } else {
                nearest.registerNestedSubclass();
            }
        }
    }

    private ClassDesc getNearestClassWithSameName(String className, String superClassName) {
        String dotAndClassName = PACKAGE_SEPARATOR.concat(className);
        return this.innerClasses.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(dotAndClassName)).map(Map.Entry::getValue).min((first, second) -> {
            int diff = Integer.compare(FinalClassCheck.classNameMatchingCount(superClassName, second.getQualifiedName()), FinalClassCheck.classNameMatchingCount(superClassName, first.getQualifiedName()));
            if (diff == 0) {
                diff = Integer.compare(first.getDepth(), second.getDepth());
            }
            return diff;
        }).orElse(null);
    }

    private static int classNameMatchingCount(String patternClass, String classToBeMatched) {
        char packageSeparator = PACKAGE_SEPARATOR.charAt(0);
        int length = Math.min(classToBeMatched.length(), patternClass.length());
        int result = 0;
        for (int i = 0; i < length && patternClass.charAt(i) == classToBeMatched.charAt(i); ++i) {
            if (patternClass.charAt(i) != packageSeparator) continue;
            result = i;
        }
        return result;
    }

    private static boolean doesNameOfClassMatchAnonymousInnerClassName(DetailAST ast, ClassDesc classDesc) {
        String[] className = classDesc.getQualifiedName().split("\\.");
        return ast.getFirstChild().getText().equals(className[className.length - 1]);
    }

    private String getQualifiedClassName(DetailAST classAst) {
        String className = classAst.findFirstToken(58).getText();
        String outerClassQualifiedName = null;
        if (!this.classes.isEmpty()) {
            outerClassQualifiedName = this.classes.peek().getQualifiedName();
        }
        return FinalClassCheck.getQualifiedClassName(this.packageName, outerClassQualifiedName, className);
    }

    private static String getQualifiedClassName(String packageName, String outerClassQualifiedName, String className) {
        Object qualifiedClassName = outerClassQualifiedName == null ? (packageName.isEmpty() ? className : packageName + PACKAGE_SEPARATOR + className) : outerClassQualifiedName + PACKAGE_SEPARATOR + className;
        return qualifiedClassName;
    }

    private static String getSuperClassName(DetailAST classAst) {
        String superClassName = null;
        DetailAST classExtend = classAst.findFirstToken(18);
        if (classExtend != null) {
            superClassName = FinalClassCheck.extractQualifiedName(classExtend.getFirstChild());
        }
        return superClassName;
    }

    private static String getClassNameFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(PACKAGE_SEPARATOR) + 1);
    }

    private static final class ClassDesc {
        private final DetailAST classAst;
        private final String qualifiedName;
        private final boolean declaredAsFinal;
        private final boolean declaredAsAbstract;
        private final int depth;
        private boolean withNonPrivateCtor;
        private boolean withPrivateCtor;
        private boolean withNestedSubclass;
        private boolean withAnonymousInnerClass;

        ClassDesc(String qualifiedName, int depth, DetailAST classAst) {
            this.qualifiedName = qualifiedName;
            this.depth = depth;
            this.classAst = classAst;
            DetailAST modifiers = classAst.findFirstToken(5);
            this.declaredAsFinal = modifiers.findFirstToken(39) != null;
            this.declaredAsAbstract = modifiers.findFirstToken(40) != null;
        }

        private String getQualifiedName() {
            return this.qualifiedName;
        }

        public DetailAST getClassAst() {
            return this.classAst;
        }

        private void registerPrivateCtor() {
            this.withPrivateCtor = true;
        }

        private void registerNonPrivateCtor() {
            this.withNonPrivateCtor = true;
        }

        private void registerNestedSubclass() {
            this.withNestedSubclass = true;
        }

        private void registerAnonymousInnerClass() {
            this.withAnonymousInnerClass = true;
        }

        private int getDepth() {
            return this.depth;
        }

        private boolean isWithPrivateCtor() {
            return this.withPrivateCtor;
        }

        private boolean isWithNonPrivateCtor() {
            return this.withNonPrivateCtor;
        }

        private boolean isWithNestedSubclass() {
            return this.withNestedSubclass;
        }

        private boolean isDeclaredAsFinal() {
            return this.declaredAsFinal;
        }

        private boolean isDeclaredAsAbstract() {
            return this.declaredAsAbstract;
        }

        private boolean isWithAnonymousInnerClass() {
            return this.withAnonymousInnerClass;
        }
    }
}

