/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.CheckstyleParserErrorStrategy;
import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.JavaAstVisitor;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageLexer;
import com.puppycrawl.tools.checkstyle.grammar.java.JavaLanguageParser;
import com.puppycrawl.tools.checkstyle.utils.ParserUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public final class JavaParser {
    private JavaParser() {
    }

    public static DetailAST parse(FileContents contents) throws CheckstyleException {
        JavaLanguageParser.CompilationUnitContext compilationUnit;
        String fullText = contents.getText().getFullText().toString();
        CodePointCharStream codePointCharStream = CharStreams.fromString((String)fullText);
        JavaLanguageLexer lexer = new JavaLanguageLexer((CharStream)codePointCharStream, true);
        lexer.setCommentListener(contents);
        lexer.removeErrorListeners();
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaLanguageParser parser = new JavaLanguageParser((TokenStream)tokenStream, 500);
        parser.setErrorHandler((ANTLRErrorStrategy)new CheckstyleParserErrorStrategy());
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new CheckstyleErrorListener());
        try {
            compilationUnit = parser.compilationUnit();
        }
        catch (IllegalStateException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred while parsing file %s.", ex.getClass().getSimpleName(), contents.getFileName());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return new JavaAstVisitor(tokenStream).visit((ParseTree)compilationUnit);
    }

    public static DetailAST parseFileText(FileText text, Options options) throws CheckstyleException {
        FileContents contents = new FileContents(text);
        DetailAST ast = JavaParser.parse(contents);
        if (options == Options.WITH_COMMENTS) {
            JavaParser.appendHiddenCommentNodes(ast);
        }
        return ast;
    }

    public static DetailAST parseFile(File file, Options options) throws IOException, CheckstyleException {
        FileText text = new FileText(file.getAbsoluteFile(), StandardCharsets.UTF_8.name());
        return JavaParser.parseFileText(text, options);
    }

    public static DetailAST appendHiddenCommentNodes(DetailAST root) {
        List<Token> hiddenAfter;
        DetailAST currentSibling;
        DetailAST curNode = root;
        DetailAST lastNode = root;
        while (curNode != null) {
            lastNode = curNode;
            List<Token> hiddenBefore = ((DetailAstImpl)curNode).getHiddenBefore();
            if (hiddenBefore != null) {
                currentSibling = curNode;
                ListIterator<Token> reverseCommentsIterator = hiddenBefore.listIterator(hiddenBefore.size());
                while (reverseCommentsIterator.hasPrevious()) {
                    DetailAST newCommentNode = JavaParser.createCommentAstFromToken((CommonToken)reverseCommentsIterator.previous());
                    ((DetailAstImpl)currentSibling).addPreviousSibling(newCommentNode);
                    currentSibling = newCommentNode;
                }
            }
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        if (lastNode != null && (hiddenAfter = ((DetailAstImpl)lastNode).getHiddenAfter()) != null) {
            currentSibling = lastNode;
            for (Token token : hiddenAfter) {
                DetailAST newCommentNode = JavaParser.createCommentAstFromToken((CommonToken)token);
                ((DetailAstImpl)currentSibling).addNextSibling(newCommentNode);
                currentSibling = newCommentNode;
            }
        }
        return root;
    }

    private static DetailAST createCommentAstFromToken(CommonToken token) {
        DetailAST commentAst = token.getType() == 144 ? JavaParser.createSlCommentNode((Token)token) : ParserUtil.createBlockCommentNode(token);
        return commentAst;
    }

    private static DetailAST createSlCommentNode(Token token) {
        DetailAstImpl slComment = new DetailAstImpl();
        slComment.setType(144);
        slComment.setText("//");
        slComment.setColumnNo(token.getCharPositionInLine());
        slComment.setLineNo(token.getLine());
        DetailAstImpl slCommentContent = new DetailAstImpl();
        slCommentContent.setType(183);
        slCommentContent.setColumnNo(token.getCharPositionInLine() + 2);
        slCommentContent.setLineNo(token.getLine());
        slCommentContent.setText(token.getText());
        slComment.addChild(slCommentContent);
        return slComment;
    }

    private static final class CheckstyleErrorListener
    extends BaseErrorListener {
        private CheckstyleErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            String message = line + ":" + charPositionInLine + ": " + msg;
            throw new IllegalStateException(message, ex);
        }
    }

    public static enum Options {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }
}

