/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressWithNearbyTextFilter
extends AbstractAutomaticBean
implements Filter {
    private static final String DEFAULT_NEARBY_TEXT_PATTERN = "SUPPRESS CHECKSTYLE (\\w+)";
    private static final String DEFAULT_CHECK_PATTERN = ".*";
    private static final String DEFAULT_LINE_RANGE = "0";
    private final List<Suppression> suppressions = new ArrayList<Suppression>();
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private Pattern nearbyTextPattern = Pattern.compile("SUPPRESS CHECKSTYLE (\\w+)");
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String checkPattern = ".*";
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String messagePattern;
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String idPattern;
    private String lineRange = "0";
    private String cachedFileAbsolutePath = "";

    public final void setNearbyTextPattern(Pattern pattern) {
        this.nearbyTextPattern = pattern;
    }

    public final void setCheckPattern(String pattern) {
        this.checkPattern = pattern;
    }

    public void setMessagePattern(String pattern) {
        this.messagePattern = pattern;
    }

    public void setIdPattern(String pattern) {
        this.idPattern = pattern;
    }

    public final void setLineRange(String format) {
        this.lineRange = format;
    }

    @Override
    public boolean accept(AuditEvent event) {
        boolean accepted = true;
        if (event.getViolation() != null) {
            FileText currentFileText;
            String eventFileTextAbsolutePath = event.getFileName();
            if (!this.cachedFileAbsolutePath.equals(eventFileTextAbsolutePath) && (currentFileText = SuppressWithNearbyTextFilter.getFileText(eventFileTextAbsolutePath)) != null) {
                this.cachedFileAbsolutePath = currentFileText.getFile().getAbsolutePath();
                this.collectSuppressions(currentFileText);
            }
            Optional<Suppression> nearestSuppression = SuppressWithNearbyTextFilter.getNearestSuppression(this.suppressions, event);
            accepted = nearestSuppression.isEmpty();
        }
        return accepted;
    }

    @Override
    protected void finishLocalSetup() {
    }

    private static FileText getFileText(String fileName) {
        File file = new File(fileName);
        FileText result = null;
        if (!file.isDirectory()) {
            try {
                result = new FileText(file, StandardCharsets.UTF_8.name());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read source file: " + fileName, ex);
            }
        }
        return result;
    }

    private void collectSuppressions(FileText fileText) {
        this.suppressions.clear();
        for (int lineNo = 0; lineNo < fileText.size(); ++lineNo) {
            Suppression suppression = this.getSuppression(fileText, lineNo);
            if (suppression == null) continue;
            this.suppressions.add(suppression);
        }
    }

    private Suppression getSuppression(FileText fileText, int lineNo) {
        String line = fileText.get(lineNo);
        Matcher nearbyTextMatcher = this.nearbyTextPattern.matcher(line);
        Suppression suppression = null;
        if (nearbyTextMatcher.find()) {
            String text = nearbyTextMatcher.group(0);
            suppression = new Suppression(text, lineNo + 1, this);
        }
        return suppression;
    }

    private static Optional<Suppression> getNearestSuppression(Collection<Suppression> suppressions, AuditEvent event) {
        return suppressions.stream().filter(suppression -> suppression.isMatch(event)).findFirst();
    }

    private static final class Suppression {
        private final int firstLine;
        private final int lastLine;
        private final Pattern eventSourceRegexp;
        private Pattern eventMessageRegexp;
        private Pattern eventIdRegexp;

        private Suppression(String text, int lineNo, SuppressWithNearbyTextFilter filter) {
            Pattern nearbyTextPattern = filter.nearbyTextPattern;
            String lineRange = filter.lineRange;
            String format = "";
            try {
                format = CommonUtil.fillTemplateWithStringsByRegexp(filter.checkPattern, text, nearbyTextPattern);
                this.eventSourceRegexp = Pattern.compile(format);
                if (filter.messagePattern != null) {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.messagePattern, text, nearbyTextPattern);
                    this.eventMessageRegexp = Pattern.compile(format);
                }
                if (filter.idPattern != null) {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.idPattern, text, nearbyTextPattern);
                    this.eventIdRegexp = Pattern.compile(format);
                }
                format = CommonUtil.fillTemplateWithStringsByRegexp(lineRange, text, nearbyTextPattern);
                int range = Suppression.parseRange(format, lineRange, text);
                this.firstLine = Math.min(lineNo, lineNo + range);
                this.lastLine = Math.max(lineNo, lineNo + range);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("unable to parse expanded comment " + format, ex);
            }
        }

        private static int parseRange(String format, String lineRange, String text) {
            try {
                return Integer.parseInt(format);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("unable to parse line range from '" + text + "' using " + lineRange, ex);
            }
        }

        private boolean isMatch(AuditEvent event) {
            return this.isInScopeOfSuppression(event) && this.isCheckMatch(event) && this.isIdMatch(event) && this.isMessageMatch(event);
        }

        private boolean isInScopeOfSuppression(AuditEvent event) {
            int eventLine = event.getLine();
            return eventLine >= this.firstLine && eventLine <= this.lastLine;
        }

        private boolean isCheckMatch(AuditEvent event) {
            Matcher checkMatcher = this.eventSourceRegexp.matcher(event.getSourceName());
            return checkMatcher.find();
        }

        private boolean isIdMatch(AuditEvent event) {
            boolean match = true;
            if (this.eventIdRegexp != null) {
                if (event.getModuleId() == null) {
                    match = false;
                } else {
                    Matcher idMatcher = this.eventIdRegexp.matcher(event.getModuleId());
                    match = idMatcher.find();
                }
            }
            return match;
        }

        private boolean isMessageMatch(AuditEvent event) {
            boolean match = true;
            if (this.eventMessageRegexp != null) {
                Matcher messageMatcher = this.eventMessageRegexp.matcher(event.getMessage());
                match = messageMatcher.find();
            }
            return match;
        }
    }
}

