/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="example")
public class ExampleMacro
extends AbstractMacro {
    private static final String XML_CONFIG_START = "/*xml";
    private static final String XML_CONFIG_END = "*/";
    private static final String CODE_SNIPPET_START = "// xdoc section -- start";
    private static final String CODE_SNIPPET_END = "// xdoc section -- end";
    private static final String NEWLINE = System.lineSeparator();
    private static final String INDENTATION = "        ";
    private String lastPath = "";
    private List<String> lastLines = new ArrayList<String>();

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        String path = (String)request.getParameter("path");
        String type = (String)request.getParameter("type");
        List<String> lines = this.lastLines;
        if (!path.equals(this.lastPath)) {
            lines = ExampleMacro.readFile("src/xdocs-examples/" + path);
            this.lastPath = path;
            this.lastLines = lines;
        }
        if ("config".equals(type)) {
            String config = ExampleMacro.getSnippetBetweenDelimiters(lines, XML_CONFIG_START, XML_CONFIG_END);
            ExampleMacro.writeSnippet(sink, config);
        } else if ("code".equals(type)) {
            String code = ExampleMacro.getSnippetBetweenDelimiters(lines, CODE_SNIPPET_START, CODE_SNIPPET_END);
            ExampleMacro.writeSnippet(sink, code);
        } else {
            String message = String.format(Locale.ROOT, "Unknown example type: %s", type);
            throw new MacroExecutionException(message);
        }
    }

    private static List<String> readFile(String path) throws MacroExecutionException {
        try {
            Path exampleFilePath = Path.of(path, new String[0]);
            return Files.readAllLines(exampleFilePath);
        }
        catch (IOException ioException) {
            String message = String.format(Locale.ROOT, "Failed to read %s", path);
            throw new MacroExecutionException(message, (Throwable)ioException);
        }
    }

    private static String getSnippetBetweenDelimiters(Collection<String> lines, String startingDelimiter, String endingDelimiter) {
        return lines.stream().dropWhile(line -> !line.contains(startingDelimiter)).skip(1L).takeWhile(line -> !line.contains(endingDelimiter)).collect(Collectors.joining(NEWLINE));
    }

    private static void writeSnippet(Sink sink, String snippet) {
        sink.verbatim(SinkEventAttributeSet.BOXED);
        String text = NEWLINE + String.join((CharSequence)NEWLINE, snippet.stripTrailing(), INDENTATION);
        sink.text(text);
        sink.verbatim_();
    }
}

