/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class UnmodifiableCollectionUtil {
    private UnmodifiableCollectionUtil() {
    }

    public static <T> Set<T> unmodifiableSet(Set<T> collection) {
        return Collections.unmodifiableSet(collection);
    }

    public static <T> List<T> unmodifiableList(List<T> collection) {
        return Collections.unmodifiableList(collection);
    }

    public static <S, T> List<T> unmodifiableList(Collection<S> items, Class<T> elementType) {
        return items.stream().map(elementType::cast).collect(Collectors.toUnmodifiableList());
    }

    public static <T> T[] copyOfArray(T[] array, int length) {
        return Arrays.copyOf(array, length);
    }

    public static <K, V> Map<K, V> copyOfMap(Map<? extends K, ? extends V> map) {
        return Map.copyOf(map);
    }

    public static <T> Set<T> singleton(T obj) {
        return Collections.singleton(obj);
    }
}

