/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@FileStatefulCheck
public class UnusedLocalVariableCheck
extends AbstractCheck {
    public static final String MSG_UNUSED_LOCAL_VARIABLE = "unused.local.var";
    private static final int[] INCREMENT_AND_DECREMENT_TOKENS = new int[]{25, 26, 129, 130};
    private static final int[] SCOPES = new int[]{7, 91, 6};
    private static final int[] UNACCEPTABLE_CHILD_OF_DOT = new int[]{59, 27, 136, 79, 69, 78};
    private static final int[] UNACCEPTABLE_PARENT_OF_IDENT = new int[]{10, 59, 136, 198, 27, 13};
    private static final int[] CONTAINERS_FOR_ANON_INNERS = new int[]{9, 8, 12, 11, 203};
    private static final String PACKAGE_SEPARATOR = ".";
    private final Deque<VariableDesc> variables = new ArrayDeque<VariableDesc>();
    private final Deque<TypeDeclDesc> typeDeclarations = new ArrayDeque<TypeDeclDesc>();
    private final Map<DetailAST, TypeDeclDesc> typeDeclAstToTypeDeclDesc = new LinkedHashMap<DetailAST, TypeDeclDesc>();
    private final Map<DetailAST, TypeDeclDesc> anonInnerAstToTypeDeclDesc = new HashMap<DetailAST, TypeDeclDesc>();
    private final Set<DetailAST> anonInnerClassHolders = new HashSet<DetailAST>();
    private String packageName;
    private int depth;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{59, 10, 58, 7, 91, 6, 14, 15, 157, 16, 136, 9, 8, 12, 11, 1, 181, 154, 199, 203};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void beginTree(DetailAST root) {
        this.variables.clear();
        this.typeDeclarations.clear();
        this.typeDeclAstToTypeDeclDesc.clear();
        this.anonInnerAstToTypeDeclDesc.clear();
        this.anonInnerClassHolders.clear();
        this.packageName = null;
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        if (type == 59) {
            UnusedLocalVariableCheck.visitDotToken(ast, this.variables);
        } else if (type == 10) {
            this.visitVariableDefToken(ast);
        } else if (type == 58) {
            UnusedLocalVariableCheck.visitIdentToken(ast, this.variables);
        } else if (UnusedLocalVariableCheck.isInsideLocalAnonInnerClass(ast)) {
            this.visitLocalAnonInnerClass(ast);
        } else if (TokenUtil.isTypeDeclaration(type)) {
            this.visitTypeDeclarationToken(ast);
        } else if (type == 16) {
            this.packageName = CheckUtil.extractQualifiedName(ast.getFirstChild().getNextSibling());
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isOfType(ast, SCOPES)) {
            this.logViolations(ast, this.variables);
        } else if (ast.getType() == 1) {
            this.leaveCompilationUnit();
        } else if (UnusedLocalVariableCheck.isNonLocalTypeDeclaration(ast)) {
            --this.depth;
            this.typeDeclarations.pop();
        }
    }

    private static void visitDotToken(DetailAST dotAst, Deque<VariableDesc> variablesStack) {
        if (dotAst.getParent().getType() != 136 && UnusedLocalVariableCheck.shouldCheckIdentTokenNestedUnderDot(dotAst)) {
            UnusedLocalVariableCheck.checkIdentifierAst(dotAst.findFirstToken(58), variablesStack);
        }
    }

    private void visitVariableDefToken(DetailAST varDefAst) {
        UnusedLocalVariableCheck.addLocalVariables(varDefAst, this.variables);
        this.addInstanceOrClassVar(varDefAst);
    }

    private static void visitIdentToken(DetailAST identAst, Deque<VariableDesc> variablesStack) {
        boolean isNestedClassInitialization;
        DetailAST parent = identAst.getParent();
        boolean isMethodReferenceMethodName = parent.getType() == 180 && parent.getFirstChild() != identAst;
        boolean isConstructorReference = parent.getType() == 180 && parent.getLastChild().getType() == 136;
        boolean bl = isNestedClassInitialization = TokenUtil.isOfType(identAst.getNextSibling(), 136) && parent.getType() == 59;
        if (isNestedClassInitialization || !isMethodReferenceMethodName && !isConstructorReference && !TokenUtil.isOfType(parent, UNACCEPTABLE_PARENT_OF_IDENT)) {
            UnusedLocalVariableCheck.checkIdentifierAst(identAst, variablesStack);
        }
    }

    private void visitTypeDeclarationToken(DetailAST typeDeclAst) {
        if (UnusedLocalVariableCheck.isNonLocalTypeDeclaration(typeDeclAst)) {
            String qualifiedName = this.getQualifiedTypeDeclarationName(typeDeclAst);
            TypeDeclDesc currTypeDecl = new TypeDeclDesc(qualifiedName, this.depth, typeDeclAst);
            ++this.depth;
            this.typeDeclarations.push(currTypeDecl);
            this.typeDeclAstToTypeDeclDesc.put(typeDeclAst, currTypeDecl);
        }
    }

    private void visitLocalAnonInnerClass(DetailAST literalNewAst) {
        this.anonInnerAstToTypeDeclDesc.put(literalNewAst, this.typeDeclarations.peek());
        this.anonInnerClassHolders.add(UnusedLocalVariableCheck.getBlockContainingLocalAnonInnerClass(literalNewAst));
    }

    private static boolean isInsideLocalAnonInnerClass(DetailAST literalNewAst) {
        boolean result = false;
        DetailAST lastChild = literalNewAst.getLastChild();
        if (lastChild != null && lastChild.getType() == 6) {
            DetailAST currentAst = literalNewAst;
            while (!TokenUtil.isTypeDeclaration(currentAst.getType())) {
                if (currentAst.getType() == 7) {
                    result = true;
                    break;
                }
                currentAst = currentAst.getParent();
            }
        }
        return result;
    }

    private void logViolations(DetailAST scopeAst, Deque<VariableDesc> variablesStack) {
        while (!variablesStack.isEmpty() && variablesStack.peek().getScope() == scopeAst) {
            VariableDesc variableDesc = variablesStack.pop();
            if (variableDesc.isUsed() || variableDesc.isInstVarOrClassVar()) continue;
            DetailAST typeAst = variableDesc.getTypeAst();
            this.log(typeAst, MSG_UNUSED_LOCAL_VARIABLE, variableDesc.getName());
        }
    }

    private void leaveCompilationUnit() {
        this.anonInnerClassHolders.forEach(holder -> this.iterateOverBlockContainingLocalAnonInnerClass((DetailAST)holder, (Deque<VariableDesc>)new ArrayDeque<VariableDesc>()));
    }

    private static boolean isNonLocalTypeDeclaration(DetailAST typeDeclAst) {
        return TokenUtil.isTypeDeclaration(typeDeclAst.getType()) && typeDeclAst.getParent().getType() != 7;
    }

    private static DetailAST getBlockContainingLocalAnonInnerClass(DetailAST literalNewAst) {
        DetailAST currentAst = literalNewAst;
        DetailAST result = null;
        while (!TokenUtil.isOfType(currentAst, CONTAINERS_FOR_ANON_INNERS)) {
            if (currentAst.getType() == 181 && currentAst.getParent().getParent().getParent().getType() == 6) {
                result = currentAst;
                break;
            }
            result = currentAst = currentAst.getParent();
        }
        return result;
    }

    private static void addLocalVariables(DetailAST varDefAst, Deque<VariableDesc> variablesStack) {
        boolean isInstanceVarInAnonymousInnerClass;
        DetailAST parentAst = varDefAst.getParent();
        DetailAST grandParent = parentAst.getParent();
        boolean bl = isInstanceVarInAnonymousInnerClass = grandParent.getType() == 136;
        if (isInstanceVarInAnonymousInnerClass || parentAst.getType() != 6) {
            DetailAST ident = varDefAst.findFirstToken(58);
            VariableDesc desc = new VariableDesc(ident.getText(), varDefAst.findFirstToken(13), UnusedLocalVariableCheck.findScopeOfVariable(varDefAst));
            if (isInstanceVarInAnonymousInnerClass) {
                desc.registerAsInstOrClassVar();
            }
            variablesStack.push(desc);
        }
    }

    private void addInstanceOrClassVar(DetailAST varDefAst) {
        DetailAST parentAst = varDefAst.getParent();
        if (UnusedLocalVariableCheck.isNonLocalTypeDeclaration(parentAst.getParent()) && !UnusedLocalVariableCheck.isPrivateInstanceVariable(varDefAst)) {
            DetailAST ident = varDefAst.findFirstToken(58);
            VariableDesc desc = new VariableDesc(ident.getText());
            this.typeDeclAstToTypeDeclDesc.get(parentAst.getParent()).addInstOrClassVar(desc);
        }
    }

    private static boolean isPrivateInstanceVariable(DetailAST varDefAst) {
        AccessModifierOption varAccessModifier = CheckUtil.getAccessModifierFromModifiersToken(varDefAst);
        return varAccessModifier == AccessModifierOption.PRIVATE;
    }

    private TypeDeclDesc getSuperClassOfAnonInnerClass(DetailAST literalNewAst) {
        TypeDeclDesc obtainedClass = null;
        String shortNameOfClass = CheckUtil.getShortNameOfAnonInnerClass(literalNewAst);
        if (this.packageName != null && shortNameOfClass.startsWith(this.packageName)) {
            Optional<TypeDeclDesc> classWithCompletePackageName = this.typeDeclAstToTypeDeclDesc.values().stream().filter(typeDeclDesc -> typeDeclDesc.getQualifiedName().equals(shortNameOfClass)).findFirst();
            if (classWithCompletePackageName.isPresent()) {
                obtainedClass = classWithCompletePackageName.orElseThrow();
            }
        } else {
            List<TypeDeclDesc> typeDeclWithSameName = this.typeDeclWithSameName(shortNameOfClass);
            if (!typeDeclWithSameName.isEmpty()) {
                obtainedClass = UnusedLocalVariableCheck.getTheNearestClass(this.anonInnerAstToTypeDeclDesc.get(literalNewAst).getQualifiedName(), typeDeclWithSameName);
            }
        }
        return obtainedClass;
    }

    private void modifyVariablesStack(TypeDeclDesc obtainedClass, Deque<VariableDesc> variablesStack, DetailAST literalNewAst) {
        if (obtainedClass != null) {
            Deque<VariableDesc> instAndClassVarDeque = this.typeDeclAstToTypeDeclDesc.get(obtainedClass.getTypeDeclAst()).getUpdatedCopyOfVarStack(literalNewAst);
            instAndClassVarDeque.forEach(variablesStack::push);
        }
    }

    private List<TypeDeclDesc> typeDeclWithSameName(String superClassName) {
        return this.typeDeclAstToTypeDeclDesc.values().stream().filter(typeDeclDesc -> this.hasSameNameAsSuperClass(superClassName, (TypeDeclDesc)typeDeclDesc)).collect(Collectors.toUnmodifiableList());
    }

    private boolean hasSameNameAsSuperClass(String superClassName, TypeDeclDesc typeDeclDesc) {
        boolean result = this.packageName == null && typeDeclDesc.getDepth() == 0 ? typeDeclDesc.getQualifiedName().equals(superClassName) : typeDeclDesc.getQualifiedName().endsWith(PACKAGE_SEPARATOR + superClassName);
        return result;
    }

    private static TypeDeclDesc getTheNearestClass(String outerTypeDeclName, List<TypeDeclDesc> typeDeclWithSameName) {
        return Collections.min(typeDeclWithSameName, (first, second) -> UnusedLocalVariableCheck.getTypeDeclarationNameMatchingCountDiff(outerTypeDeclName, first, second));
    }

    private static int getTypeDeclarationNameMatchingCountDiff(String outerTypeDeclName, TypeDeclDesc firstTypeDecl, TypeDeclDesc secondTypeDecl) {
        int diff = Integer.compare(CheckUtil.typeDeclarationNameMatchingCount(outerTypeDeclName, secondTypeDecl.getQualifiedName()), CheckUtil.typeDeclarationNameMatchingCount(outerTypeDeclName, firstTypeDecl.getQualifiedName()));
        if (diff == 0) {
            diff = Integer.compare(firstTypeDecl.getDepth(), secondTypeDecl.getDepth());
        }
        return diff;
    }

    private String getQualifiedTypeDeclarationName(DetailAST typeDeclAst) {
        String className = typeDeclAst.findFirstToken(58).getText();
        String outerClassQualifiedName = null;
        if (!this.typeDeclarations.isEmpty()) {
            outerClassQualifiedName = this.typeDeclarations.peek().getQualifiedName();
        }
        return CheckUtil.getQualifiedTypeDeclarationName(this.packageName, outerClassQualifiedName, className);
    }

    private void iterateOverBlockContainingLocalAnonInnerClass(DetailAST ast, Deque<VariableDesc> variablesStack) {
        DetailAST currNode = ast;
        while (currNode != null) {
            this.customVisitToken(currNode, variablesStack);
            DetailAST toVisit = currNode.getFirstChild();
            while (currNode != ast && toVisit == null) {
                this.customLeaveToken(currNode, variablesStack);
                toVisit = currNode.getNextSibling();
                currNode = currNode.getParent();
            }
            currNode = toVisit;
        }
    }

    private void customVisitToken(DetailAST ast, Deque<VariableDesc> variablesStack) {
        int type = ast.getType();
        if (type == 59) {
            UnusedLocalVariableCheck.visitDotToken(ast, variablesStack);
        } else if (type == 10) {
            UnusedLocalVariableCheck.addLocalVariables(ast, variablesStack);
        } else if (type == 58) {
            UnusedLocalVariableCheck.visitIdentToken(ast, variablesStack);
        } else if (UnusedLocalVariableCheck.isInsideLocalAnonInnerClass(ast)) {
            TypeDeclDesc obtainedClass = this.getSuperClassOfAnonInnerClass(ast);
            this.modifyVariablesStack(obtainedClass, variablesStack, ast);
        }
    }

    private void customLeaveToken(DetailAST ast, Deque<VariableDesc> variablesStack) {
        this.logViolations(ast, variablesStack);
    }

    private static boolean shouldCheckIdentTokenNestedUnderDot(DetailAST dotAst) {
        return TokenUtil.findFirstTokenByPredicate(dotAst, childAst -> TokenUtil.isOfType(childAst, UNACCEPTABLE_CHILD_OF_DOT)).isEmpty();
    }

    private static void checkIdentifierAst(DetailAST identAst, Deque<VariableDesc> variablesStack) {
        for (VariableDesc variableDesc : variablesStack) {
            if (!identAst.getText().equals(variableDesc.getName()) || UnusedLocalVariableCheck.isLeftHandSideValue(identAst)) continue;
            variableDesc.registerAsUsed();
            break;
        }
    }

    private static DetailAST findScopeOfVariable(DetailAST variableDef) {
        DetailAST parentAst = variableDef.getParent();
        DetailAST result = TokenUtil.isOfType(parentAst, 7, 6) ? parentAst : parentAst.getParent();
        return result;
    }

    private static boolean isLeftHandSideValue(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        return UnusedLocalVariableCheck.isStandAloneIncrementOrDecrement(identAst) || parent.getType() == 80 && identAst != parent.getLastChild();
    }

    private static boolean isStandAloneIncrementOrDecrement(DetailAST identAst) {
        DetailAST parent = identAst.getParent();
        DetailAST grandParent = parent.getParent();
        return TokenUtil.isOfType(parent, INCREMENT_AND_DECREMENT_TOKENS) && TokenUtil.isOfType(grandParent, 28) && !UnusedLocalVariableCheck.isIncrementOrDecrementVariableUsed(grandParent);
    }

    private static boolean isIncrementOrDecrementVariableUsed(DetailAST exprAst) {
        return TokenUtil.isOfType(exprAst.getParent(), 34, 24, 80) && exprAst.getParent().getParent().getType() != 37;
    }

    private static final class TypeDeclDesc {
        private final String qualifiedName;
        private final int depth;
        private final DetailAST typeDeclAst;
        private final Deque<VariableDesc> instanceAndClassVarStack;

        private TypeDeclDesc(String qualifiedName, int depth, DetailAST typeDeclAst) {
            this.qualifiedName = qualifiedName;
            this.depth = depth;
            this.typeDeclAst = typeDeclAst;
            this.instanceAndClassVarStack = new ArrayDeque<VariableDesc>();
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public int getDepth() {
            return this.depth;
        }

        public DetailAST getTypeDeclAst() {
            return this.typeDeclAst;
        }

        public Deque<VariableDesc> getUpdatedCopyOfVarStack(DetailAST literalNewAst) {
            DetailAST updatedScope = literalNewAst;
            ArrayDeque<VariableDesc> instAndClassVarDeque = new ArrayDeque<VariableDesc>();
            this.instanceAndClassVarStack.forEach(instVar -> {
                VariableDesc variableDesc = new VariableDesc(instVar.getName(), updatedScope);
                variableDesc.registerAsInstOrClassVar();
                instAndClassVarDeque.push(variableDesc);
            });
            return instAndClassVarDeque;
        }

        public void addInstOrClassVar(VariableDesc variableDesc) {
            this.instanceAndClassVarStack.push(variableDesc);
        }
    }

    private static final class VariableDesc {
        private final String name;
        private final DetailAST typeAst;
        private final DetailAST scope;
        private boolean instVarOrClassVar;
        private boolean used;

        private VariableDesc(String name, DetailAST typeAst, DetailAST scope) {
            this.name = name;
            this.typeAst = typeAst;
            this.scope = scope;
        }

        private VariableDesc(String name) {
            this(name, null, null);
        }

        private VariableDesc(String name, DetailAST scope) {
            this(name, null, scope);
        }

        public String getName() {
            return this.name;
        }

        public DetailAST getTypeAst() {
            return this.typeAst;
        }

        public DetailAST getScope() {
            return this.scope;
        }

        public void registerAsUsed() {
            this.used = true;
        }

        public void registerAsInstOrClassVar() {
            this.instVarOrClassVar = true;
        }

        public boolean isUsed() {
            return this.used;
        }

        public boolean isInstVarOrClassVar() {
            return this.instVarOrClassVar;
        }
    }
}

