/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@StatelessCheck
public class MethodLengthCheck
extends AbstractCheck {
    public static final String MSG_KEY = "maxLen.method";
    private static final int DEFAULT_MAX_LINES = 150;
    private boolean countEmpty = true;
    private int max = 150;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST openingBrace = ast.findFirstToken(7);
        if (openingBrace != null) {
            int length;
            if (this.countEmpty) {
                DetailAST closingBrace = openingBrace.findFirstToken(73);
                length = MethodLengthCheck.getLengthOfBlock(openingBrace, closingBrace);
            } else {
                length = MethodLengthCheck.countUsedLines(openingBrace);
            }
            if (length > this.max) {
                String methodName = ast.findFirstToken(58).getText();
                this.log(ast, MSG_KEY, length, this.max, methodName);
            }
        }
    }

    private static int getLengthOfBlock(DetailAST openingBrace, DetailAST closingBrace) {
        int startLineNo = openingBrace.getLineNo();
        int endLineNo = closingBrace.getLineNo();
        return endLineNo - startLineNo + 1;
    }

    private static int countUsedLines(DetailAST ast) {
        ArrayDeque<DetailAST> nodes = new ArrayDeque<DetailAST>();
        nodes.add(ast);
        HashSet<Integer> usedLines = new HashSet<Integer>();
        while (!nodes.isEmpty()) {
            DetailAST node = (DetailAST)nodes.removeFirst();
            int lineNo = node.getLineNo();
            if (node.getType() == 204) {
                IntStream.rangeClosed(lineNo, node.getLastChild().getLineNo()).forEach(usedLines::add);
                continue;
            }
            usedLines.add(lineNo);
            Stream.iterate(node.getLastChild(), Objects::nonNull, DetailAST::getPreviousSibling).forEach(nodes::addFirst);
        }
        return usedLines.size();
    }

    public void setMax(int length) {
        this.max = length;
    }

    public void setCountEmpty(boolean countEmpty) {
        this.countEmpty = countEmpty;
    }
}

