/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import java.util.Arrays;

@StatelessCheck
public class RecordComponentNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "too.many.components";
    private static final int DEFAULT_MAX_COMPONENTS = 8;
    private int max = 8;
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};

    public void setMax(int value) {
        this.max = value;
    }

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = Arrays.copyOf(accessModifiers, accessModifiers.length);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{199};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST recordComponents;
        int componentCount;
        AccessModifierOption accessModifier = CheckUtil.getAccessModifierFromModifiersToken(ast);
        if (this.matchAccessModifiers(accessModifier) && (componentCount = RecordComponentNumberCheck.countComponents(recordComponents = ast.findFirstToken(201))) > this.max) {
            this.log(ast, MSG_KEY, componentCount, this.max);
        }
    }

    private static int countComponents(DetailAST recordComponents) {
        return recordComponents.getChildCount(202);
    }

    private boolean matchAccessModifiers(AccessModifierOption accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }
}

