/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@FileStatefulCheck
public abstract class AbstractClassCouplingCheck
extends AbstractCheck {
    private static final char DOT = '.';
    private static final Set<String> DEFAULT_EXCLUDED_CLASSES = Set.of("var", "boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Short", "Void", "Object", "Class", "String", "StringBuffer", "StringBuilder", "ArrayIndexOutOfBoundsException", "Exception", "RuntimeException", "IllegalArgumentException", "IllegalStateException", "IndexOutOfBoundsException", "NullPointerException", "Throwable", "SecurityException", "UnsupportedOperationException", "List", "ArrayList", "Deque", "Queue", "LinkedList", "Set", "HashSet", "SortedSet", "TreeSet", "Map", "HashMap", "SortedMap", "TreeMap", "Override", "Deprecated", "SafeVarargs", "SuppressWarnings", "FunctionalInterface", "Collection", "EnumSet", "LinkedHashMap", "LinkedHashSet", "Optional", "OptionalDouble", "OptionalInt", "OptionalLong", "DoubleStream", "IntStream", "LongStream", "Stream");
    private static final Set<String> DEFAULT_EXCLUDED_PACKAGES = Collections.emptySet();
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\[[^]]*]");
    private final List<Pattern> excludeClassesRegexps = new ArrayList<Pattern>();
    private final Map<String, String> importedClassPackages = new HashMap<String, String>();
    private final Deque<ClassContext> classesContexts = new ArrayDeque<ClassContext>();
    private Set<String> excludedClasses = DEFAULT_EXCLUDED_CLASSES;
    private Set<String> excludedPackages = DEFAULT_EXCLUDED_PACKAGES;
    private int max;
    private String packageName;

    protected AbstractClassCouplingCheck(int defaultMax) {
        this.max = defaultMax;
        this.excludeClassesRegexps.add(CommonUtil.createPattern("^$"));
    }

    protected abstract String getLogMessageId();

    @Override
    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public final void setMax(int max) {
        this.max = max;
    }

    public final void setExcludedClasses(String ... excludedClasses) {
        this.excludedClasses = Set.of(excludedClasses);
    }

    public void setExcludeClassesRegexps(String ... from) {
        Arrays.stream(from).map(CommonUtil::createPattern).distinct().forEach(this.excludeClassesRegexps::add);
    }

    public final void setExcludedPackages(String ... excludedPackages) {
        List invalidIdentifiers = Arrays.stream(excludedPackages).filter(Predicate.not(CommonUtil::isName)).collect(Collectors.toList());
        if (!invalidIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("the following values are not valid identifiers: " + invalidIdentifiers);
        }
        this.excludedPackages = Set.of(excludedPackages);
    }

    @Override
    public final void beginTree(DetailAST ast) {
        this.importedClassPackages.clear();
        this.classesContexts.clear();
        this.classesContexts.push(new ClassContext("", null));
        this.packageName = "";
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.visitPackageDef(ast);
                break;
            }
            case 30: {
                this.registerImport(ast);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: 
            case 199: {
                this.visitClassDef(ast);
                break;
            }
            case 13: 
            case 18: 
            case 19: {
                this.visitType(ast);
                break;
            }
            case 136: {
                this.visitLiteralNew(ast);
                break;
            }
            case 81: {
                this.visitLiteralThrows(ast);
                break;
            }
            case 159: {
                this.visitAnnotationType(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isTypeDeclaration(ast.getType())) {
            this.leaveClassDef();
        }
    }

    private void visitPackageDef(DetailAST pkg) {
        FullIdent ident = FullIdent.createFullIdent(pkg.getLastChild().getPreviousSibling());
        this.packageName = ident.getText();
    }

    private void visitClassDef(DetailAST classDef) {
        String className = classDef.findFirstToken(58).getText();
        this.createNewClassContext(className, classDef);
    }

    private void leaveClassDef() {
        this.checkCurrentClassAndRestorePrevious();
    }

    private void registerImport(DetailAST imp) {
        FullIdent ident = FullIdent.createFullIdent(imp.getLastChild().getPreviousSibling());
        String fullName = ident.getText();
        int lastDot = fullName.lastIndexOf(46);
        this.importedClassPackages.put(fullName.substring(lastDot + 1), fullName);
    }

    private void createNewClassContext(String className, DetailAST ast) {
        this.classesContexts.push(new ClassContext(className, ast));
    }

    private void checkCurrentClassAndRestorePrevious() {
        this.classesContexts.pop().checkCoupling();
    }

    private void visitType(DetailAST ast) {
        this.classesContexts.peek().visitType(ast);
    }

    private void visitLiteralNew(DetailAST ast) {
        this.classesContexts.peek().visitLiteralNew(ast);
    }

    private void visitLiteralThrows(DetailAST ast) {
        this.classesContexts.peek().visitLiteralThrows(ast);
    }

    private void visitAnnotationType(DetailAST annotationAST) {
        DetailAST children = annotationAST.getFirstChild();
        DetailAST type = children.getNextSibling();
        this.classesContexts.peek().addReferencedClassName(type.getText());
    }

    private final class ClassContext {
        private final Set<String> referencedClassNames = new TreeSet<String>();
        private final String className;
        private final DetailAST classAst;

        private ClassContext(String className, DetailAST ast) {
            this.className = className;
            this.classAst = ast;
        }

        public void visitLiteralThrows(DetailAST literalThrows) {
            for (DetailAST childAST = literalThrows.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                if (childAST.getType() == 74) continue;
                this.addReferencedClassName(childAST);
            }
        }

        public void visitType(DetailAST ast) {
            for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!TokenUtil.isOfType(child, 58, 59)) continue;
                String fullTypeName = FullIdent.createFullIdent(child).getText();
                String trimmed = BRACKET_PATTERN.matcher(fullTypeName).replaceAll("");
                this.addReferencedClassName(trimmed);
            }
        }

        public void visitLiteralNew(DetailAST ast) {
            this.addReferencedClassName(ast.getFirstChild());
        }

        private void addReferencedClassName(DetailAST ast) {
            String fullIdentName = FullIdent.createFullIdent(ast).getText();
            String trimmed = BRACKET_PATTERN.matcher(fullIdentName).replaceAll("");
            this.addReferencedClassName(trimmed);
        }

        private void addReferencedClassName(String referencedClassName) {
            if (this.isSignificant(referencedClassName)) {
                this.referencedClassNames.add(referencedClassName);
            }
        }

        public void checkCoupling() {
            this.referencedClassNames.remove(this.className);
            this.referencedClassNames.remove(AbstractClassCouplingCheck.this.packageName + "." + this.className);
            if (this.referencedClassNames.size() > AbstractClassCouplingCheck.this.max) {
                AbstractClassCouplingCheck.this.log(this.classAst, AbstractClassCouplingCheck.this.getLogMessageId(), this.referencedClassNames.size(), AbstractClassCouplingCheck.this.max, this.referencedClassNames.toString());
            }
        }

        private boolean isSignificant(String candidateClassName) {
            return !AbstractClassCouplingCheck.this.excludedClasses.contains(candidateClassName) && !this.isFromExcludedPackage(candidateClassName) && !this.isExcludedClassRegexp(candidateClassName);
        }

        private boolean isFromExcludedPackage(String candidateClassName) {
            String classNameWithPackage = candidateClassName;
            if (candidateClassName.indexOf(46) == -1) {
                classNameWithPackage = this.getClassNameWithPackage(candidateClassName).orElse("");
            }
            boolean isFromExcludedPackage = false;
            if (classNameWithPackage.indexOf(46) != -1) {
                int lastDotIndex = classNameWithPackage.lastIndexOf(46);
                String candidatePackageName = classNameWithPackage.substring(0, lastDotIndex);
                isFromExcludedPackage = candidatePackageName.startsWith("java.lang") || AbstractClassCouplingCheck.this.excludedPackages.contains(candidatePackageName);
            }
            return isFromExcludedPackage;
        }

        private Optional<String> getClassNameWithPackage(String examineClassName) {
            return Optional.ofNullable(AbstractClassCouplingCheck.this.importedClassPackages.get(examineClassName));
        }

        private boolean isExcludedClassRegexp(String candidateClassName) {
            boolean result = false;
            for (Pattern pattern : AbstractClassCouplingCheck.this.excludeClassesRegexps) {
                if (!pattern.matcher(candidateClassName).matches()) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

