/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.meta.JavadocMetadataScraper;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="description")
public class DescriptionMacro
extends AbstractMacro {
    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Path modulePath = Paths.get((String)request.getParameter("modulePath"), new String[0]);
        String moduleName = CommonUtil.getFileNameWithoutExtension(modulePath.toString());
        Set<String> propertyNames = ModuleJavadocParsingUtil.getPropertyNames(moduleName);
        DetailNode moduleJavadoc = SiteUtil.getModuleJavadoc(moduleName, modulePath);
        if (moduleJavadoc == null) {
            throw new MacroExecutionException("Javadoc of module " + moduleName + " is not found.");
        }
        int descriptionEndIndex = DescriptionMacro.getDescriptionEndIndex(moduleJavadoc, propertyNames);
        String moduleDescription = JavadocMetadataScraper.constructSubTreeText(moduleJavadoc, 0, descriptionEndIndex);
        ModuleJavadocParsingUtil.writeOutJavadocPortion(moduleDescription, sink);
    }

    private static int getDescriptionEndIndex(DetailNode moduleJavadoc, Set<String> propertyNamesSet) {
        int descriptionEndIndex = -1;
        int notesStartingIndex = ModuleJavadocParsingUtil.getNotesSectionStartIndex(moduleJavadoc);
        descriptionEndIndex = notesStartingIndex > -1 ? (descriptionEndIndex += notesStartingIndex) : (propertyNamesSet.isEmpty() ? (descriptionEndIndex += ModuleJavadocParsingUtil.getParentSectionStartIndex(moduleJavadoc)) : (descriptionEndIndex += ModuleJavadocParsingUtil.getPropertySectionStartIndex(moduleJavadoc, propertyNamesSet)));
        return descriptionEndIndex;
    }
}

