/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@StatelessCheck
public class RequireEmptyLineBeforeBlockTagGroupCheck
extends AbstractJavadocCheck {
    public static final String MSG_JAVADOC_TAG_LINE_BEFORE = "javadoc.tag.line.before";
    private static final List<Integer> ONLY_TAG_VARIATION_1 = Arrays.asList(4, 2, 3);
    private static final List<Integer> ONLY_TAG_VARIATION_2 = Arrays.asList(2, 3);

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{75};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode tagNode) {
        if (!RequireEmptyLineBeforeBlockTagGroupCheck.isAnotherTagBefore(tagNode) && !RequireEmptyLineBeforeBlockTagGroupCheck.isOnlyTagInWholeJavadoc(tagNode) && RequireEmptyLineBeforeBlockTagGroupCheck.hasInsufficientConsecutiveNewlines(tagNode)) {
            String tagName = JavadocUtil.getTagName(tagNode);
            this.log(tagNode.getLineNumber(), MSG_JAVADOC_TAG_LINE_BEFORE, "@" + tagName);
        }
    }

    private static boolean isAnotherTagBefore(DetailNode tagNode) {
        boolean found = false;
        for (DetailNode currentNode = tagNode.getPreviousSibling(); currentNode != null; currentNode = currentNode.getPreviousSibling()) {
            if (currentNode.getType() != 75) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean isOnlyTagInWholeJavadoc(DetailNode tagNode) {
        ArrayList<Integer> previousNodeTypes = new ArrayList<Integer>();
        for (DetailNode currentNode = tagNode.getPreviousSibling(); currentNode != null; currentNode = currentNode.getPreviousSibling()) {
            previousNodeTypes.add(currentNode.getType());
        }
        return ONLY_TAG_VARIATION_1.equals(previousNodeTypes) || ONLY_TAG_VARIATION_2.equals(previousNodeTypes);
    }

    private static boolean hasInsufficientConsecutiveNewlines(DetailNode tagNode) {
        int count = 0;
        for (DetailNode currentNode = tagNode.getPreviousSibling(); currentNode != null && (CommonUtil.isBlank(currentNode.getText()) || currentNode.getType() == 2); currentNode = currentNode.getPreviousSibling()) {
            if (currentNode.getType() != 3) continue;
            ++count;
        }
        return count <= 1;
    }
}

