/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@StatelessCheck
public class HexLiteralCaseCheck
extends AbstractCheck {
    public static final String MSG_KEY = "hex.literal";
    private static final int A_ASCII = 97;
    private static final int F_ASCII = 102;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{141, 137};
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        if ((text.startsWith("0x") || text.startsWith("0X")) && HexLiteralCaseCheck.containsLowerLetter(text)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean containsLowerLetter(String text) {
        char[] characterList;
        boolean result = false;
        for (char character : characterList = text.toCharArray()) {
            if (character < 'a' || character > 'f') continue;
            result = true;
            break;
        }
        return result;
    }
}

