/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.BitSet;
import java.util.function.Predicate;

@StatelessCheck
public class AvoidDoubleBraceInitializationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.double.brace.init";
    private static final BitSet IGNORED_TYPES = TokenUtil.asBitSet(11, 45, 72, 73);
    private static final Predicate<DetailAST> HAS_MEMBERS = token -> !IGNORED_TYPES.get(token.getType());

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{6};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getParent().getType() == 136 && AvoidDoubleBraceInitializationCheck.hasOnlyInitialization(ast)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean hasOnlyInitialization(DetailAST objBlock) {
        boolean hasInitBlock = objBlock.findFirstToken(11) != null;
        return hasInitBlock && TokenUtil.findFirstTokenByPredicate(objBlock, HAS_MEMBERS).isEmpty();
    }
}

