/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocMetadataScraperUtil {
    private static final Pattern TOKEN_TEXT_PATTERN = Pattern.compile("([A-Z_]{2,})+");

    private JavadocMetadataScraperUtil() {
    }

    public static String constructSubTreeText(DetailNode startNode, DetailNode endNode) {
        DetailNode curNode = startNode;
        StringBuilder result = new StringBuilder(1024);
        while (curNode != null) {
            if (JavadocMetadataScraperUtil.isContentToWrite(curNode)) {
                String childText = curNode.getText();
                if (JavadocMetadataScraperUtil.isInsideCodeInlineTag(curNode)) {
                    childText = JavadocMetadataScraperUtil.adjustCodeInlineTagChildToHtml(curNode);
                }
                result.append(childText);
            }
            DetailNode toVisit = curNode.getFirstChild();
            while (curNode != endNode && toVisit == null) {
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
        return result.toString().trim();
    }

    private static boolean isInsideCodeInlineTag(DetailNode node) {
        return node.getParent() != null && node.getParent().getType() == 76;
    }

    private static boolean isContentToWrite(DetailNode detailNode) {
        return detailNode.getType() != 2 && (detailNode.getType() == 4 || !TOKEN_TEXT_PATTERN.matcher(detailNode.getText()).matches());
    }

    public static String adjustCodeInlineTagChildToHtml(DetailNode codeChild) {
        return switch (codeChild.getType()) {
            case 8 -> "</code>";
            case 26 -> "";
            case 7 -> "<code>";
            default -> codeChild.getText().trim();
        };
    }

    private static Optional<DetailNode> getFirstChildOfType(DetailNode node, int tokenType) {
        return JavadocUtil.getAllNodesOfType(node, tokenType).stream().findFirst();
    }

    public static boolean isChildNodeTextMatches(DetailNode ast, Pattern pattern) {
        return JavadocMetadataScraperUtil.getFirstChildOfType(ast, 4).map(DetailNode::getText).map(pattern::matcher).map(Matcher::matches).orElse(Boolean.FALSE);
    }
}

