/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.checks.ClassResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeAwareCheck
extends Check {
    private final Set<String> mImports = Sets.newHashSet();
    private FullIdent mPackageFullIdent;
    private String mCurrentClass;
    private ClassResolver mClassResolver;
    private final FastStack<Map<String, ClassInfo>> mTypeParams = FastStack.newInstance();
    private boolean mLogLoadErrors;
    private boolean mSuppressLoadErrors;

    public final void setLogLoadErrors(boolean aLogLoadErrors) {
        this.mLogLoadErrors = aLogLoadErrors;
    }

    public final void setSuppressLoadErrors(boolean aSuppressLoadErrors) {
        this.mSuppressLoadErrors = aSuppressLoadErrors;
    }

    protected abstract void processAST(DetailAST var1);

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{16, 30, 14, 154};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mPackageFullIdent = FullIdent.createFullIdent(null);
        this.mImports.clear();
        this.mImports.add("java.lang.*");
        this.mClassResolver = null;
        this.mCurrentClass = "";
        this.mTypeParams.clear();
    }

    @Override
    public final void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            this.processPackage(aAST);
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else if (aAST.getType() == 14 || aAST.getType() == 154) {
            this.processClass(aAST);
        } else {
            if (aAST.getType() == 9) {
                this.processTypeParams(aAST);
            }
            this.processAST(aAST);
        }
    }

    @Override
    public final void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14 || aAST.getType() == 154) {
            int dotIdx = this.mCurrentClass.lastIndexOf("$");
            if (dotIdx == -1) {
                dotIdx = this.mCurrentClass.lastIndexOf(".");
            }
            this.mCurrentClass = dotIdx == -1 ? "" : this.mCurrentClass.substring(0, dotIdx);
            this.mTypeParams.pop();
        } else if (aAST.getType() == 9) {
            this.mTypeParams.pop();
        } else if (aAST.getType() != 16 && aAST.getType() != 30) {
            this.leaveAST(aAST);
        }
    }

    protected void leaveAST(DetailAST aAST) {
    }

    protected boolean isUnchecked(Class<?> aException) {
        return this.isSubclass(aException, RuntimeException.class) || this.isSubclass(aException, Error.class);
    }

    protected boolean isSubclass(Class<?> aChild, Class<?> aParent) {
        return aParent != null && aChild != null && aParent.isAssignableFrom(aChild);
    }

    private ClassResolver getClassResolver() {
        if (this.mClassResolver == null) {
            this.mClassResolver = new ClassResolver(this.getClassLoader(), this.mPackageFullIdent.getText(), this.mImports);
        }
        return this.mClassResolver;
    }

    protected final Class<?> resolveClass(String aClassName, String aCurrentClass) {
        try {
            return this.getClassResolver().resolve(aClassName, aCurrentClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected final Class<?> tryLoadClass(Token aIdent, String aCurrentClass) {
        Class<?> clazz = this.resolveClass(aIdent.getText(), aCurrentClass);
        if (clazz == null) {
            this.logLoadError(aIdent);
        }
        return clazz;
    }

    protected abstract void logLoadError(Token var1);

    protected final void logLoadErrorImpl(int aLineNo, int aColumnNo, String aMsgKey, Object ... aValues) {
        if (!this.mLogLoadErrors) {
            LocalizedMessage msg = new LocalizedMessage(aLineNo, aColumnNo, this.getMessageBundle(), aMsgKey, aValues, this.getSeverityLevel(), this.getId(), this.getClass(), null);
            throw new RuntimeException(msg.getMessage());
        }
        if (!this.mSuppressLoadErrors) {
            this.log(aLineNo, aColumnNo, aMsgKey, aValues);
        }
    }

    private void processPackage(DetailAST aAST) {
        DetailAST nameAST = aAST.getLastChild().getPreviousSibling();
        this.mPackageFullIdent = FullIdent.createFullIdent(nameAST);
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null) {
            this.mImports.add(name.getText());
        }
    }

    private void processTypeParams(DetailAST aAST) {
        DetailAST typeParams = aAST.findFirstToken(165);
        HashMap paramsMap = Maps.newHashMap();
        this.mTypeParams.push(paramsMap);
        if (typeParams == null) {
            return;
        }
        for (DetailAST child = typeParams.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 166) continue;
            DetailAST param = child;
            String alias = param.findFirstToken(58).getText();
            DetailAST bounds = param.findFirstToken(168);
            if (bounds == null) continue;
            FullIdent name = FullIdent.createFullIdentBelow(bounds);
            ClassInfo ci = this.createClassInfo(new Token(name), this.getCurrentClassName());
            paramsMap.put(alias, ci);
        }
    }

    private void processClass(DetailAST aAST) {
        DetailAST ident = aAST.findFirstToken(58);
        this.mCurrentClass = this.mCurrentClass + ("".equals(this.mCurrentClass) ? "" : "$") + ident.getText();
        this.processTypeParams(aAST);
    }

    protected final String getCurrentClassName() {
        return this.mCurrentClass;
    }

    protected final ClassInfo createClassInfo(Token aName, String aSurroundingClass) {
        ClassInfo ci = this.findClassAlias(aName.getText());
        if (ci != null) {
            return new ClassAlias(aName, ci);
        }
        return new RegularClass(aName, aSurroundingClass, this);
    }

    protected final ClassInfo findClassAlias(String aName) {
        Map<String, ClassInfo> paramMap;
        ClassInfo ci = null;
        for (int i = this.mTypeParams.size() - 1; i >= 0 && (ci = (paramMap = this.mTypeParams.peek(i)).get(aName)) == null; --i) {
        }
        return ci;
    }

    protected static class Token {
        private final int mColumn;
        private final int mLine;
        private final String mText;

        public Token(String aText, int aLine, int aColumn) {
            this.mText = aText;
            this.mLine = aLine;
            this.mColumn = aColumn;
        }

        public Token(FullIdent aFullIdent) {
            this.mText = aFullIdent.getText();
            this.mLine = aFullIdent.getLineNo();
            this.mColumn = aFullIdent.getColumnNo();
        }

        public int getLineNo() {
            return this.mLine;
        }

        public int getColumnNo() {
            return this.mColumn;
        }

        public String getText() {
            return this.mText;
        }

        public String toString() {
            return "Token[" + this.getText() + "(" + this.getLineNo() + "x" + this.getColumnNo() + ")]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassAlias
    extends ClassInfo {
        private final ClassInfo mClassInfo;

        ClassAlias(Token aName, ClassInfo aClassInfo) {
            super(aName);
            this.mClassInfo = aClassInfo;
        }

        @Override
        public final Class<?> getClazz() {
            return this.mClassInfo.getClazz();
        }

        public String toString() {
            return "ClassAlias[alias " + this.getName() + " for " + this.mClassInfo + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularClass
    extends ClassInfo {
        private final String mSurroundingClass;
        private boolean mIsLoadable = true;
        private Class<?> mClass;
        private final AbstractTypeAwareCheck mCheck;

        private RegularClass(Token aName, String aSurroundingClass, AbstractTypeAwareCheck aCheck) {
            super(aName);
            this.mSurroundingClass = aSurroundingClass;
            this.mCheck = aCheck;
        }

        private boolean isLoadable() {
            return this.mIsLoadable;
        }

        @Override
        public Class<?> getClazz() {
            if (this.isLoadable() && this.mClass == null) {
                this.setClazz(this.mCheck.tryLoadClass(this.getName(), this.mSurroundingClass));
            }
            return this.mClass;
        }

        private void setClazz(Class<?> aClass) {
            this.mClass = aClass;
            this.mIsLoadable = this.mClass != null;
        }

        public String toString() {
            return "RegularClass[name=" + this.getName() + ", in class=" + this.mSurroundingClass + ", loadable=" + this.mIsLoadable + ", class=" + this.mClass + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ClassInfo {
        private final Token mName;

        public final Token getName() {
            return this.mName;
        }

        public abstract Class<?> getClazz();

        protected ClassInfo(Token aName) {
            if (aName == null) {
                throw new NullPointerException("ClassInfo's name should be non-null");
            }
            this.mName = aName;
        }
    }
}

