/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class OneStatementPerLineCheck
extends Check {
    private int mLastStatementEnd = -1;
    private int mExprDepth;
    private boolean mInForHeader;

    public int[] getDefaultTokens() {
        return new int[]{28, 45, 35, 37};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mExprDepth = 0;
        this.mInForHeader = false;
        this.mLastStatementEnd = -1;
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 28: {
                this.visitExpr(aAst);
                break;
            }
            case 45: {
                this.visitSemi(aAst);
                break;
            }
            case 35: {
                this.mInForHeader = true;
                break;
            }
        }
    }

    public void leaveToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 37: {
                this.mInForHeader = false;
                break;
            }
            case 28: {
                --this.mExprDepth;
                break;
            }
        }
    }

    private void visitExpr(DetailAST aAst) {
        ++this.mExprDepth;
        if (this.mExprDepth == 1 && !this.mInForHeader && this.mLastStatementEnd == aAst.getLineNo()) {
            this.log(aAst, "multiple.statements.line", new Object[0]);
        }
    }

    private void visitSemi(DetailAST aAst) {
        if (this.mExprDepth == 0) {
            this.mLastStatementEnd = aAst.getLineNo();
        }
    }
}

